/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.data;

import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.hipparchus.exception.DummyLocalizable;
import org.hipparchus.exception.Localizable;
import org.orekit.data.DataLoader;
import org.orekit.data.DataProvider;
import org.orekit.data.DataProvidersManager;
import org.orekit.data.DataSource;
import org.orekit.data.ZipJarCrawler;
import org.orekit.errors.OrekitException;

public abstract class AbstractListCrawler<T>
implements DataProvider {
    private final List<T> inputs;

    @SafeVarargs
    protected AbstractListCrawler(T ... inputs) {
        this.inputs = Arrays.stream(inputs).collect(Collectors.toList());
    }

    public void addInput(T input) {
        this.inputs.add(input);
    }

    public List<T> getInputs() {
        return Collections.unmodifiableList(this.inputs);
    }

    protected abstract String getCompleteName(T var1);

    protected abstract String getBaseName(T var1);

    protected abstract ZipJarCrawler getZipJarCrawler(T var1);

    protected abstract InputStream getStream(T var1) throws IOException;

    @Override
    public boolean feed(Pattern supported, DataLoader visitor, DataProvidersManager manager) {
        try {
            OrekitException delayedException = null;
            boolean loaded = false;
            for (T input : this.inputs) {
                try {
                    if (!visitor.stillAcceptsData()) continue;
                    String name = this.getCompleteName(input);
                    String fileName = this.getBaseName(input);
                    if (ZIP_ARCHIVE_PATTERN.matcher(fileName).matches()) {
                        this.getZipJarCrawler(input).feed(supported, visitor, manager);
                        loaded = true;
                        continue;
                    }
                    DataSource data = new DataSource(fileName, () -> this.getStream(input));
                    data = manager.getFiltersManager().applyRelevantFilters(data);
                    if (!supported.matcher(data.getName()).matches()) continue;
                    InputStream is = data.getOpener().openStreamOnce();
                    Throwable throwable = null;
                    try {
                        visitor.loadData(is, name);
                        loaded = true;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (is == null) continue;
                        if (throwable != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        is.close();
                    }
                }
                catch (OrekitException oe) {
                    delayedException = oe;
                }
            }
            if (!loaded && delayedException != null) {
                throw delayedException;
            }
            return loaded;
        }
        catch (IOException | ParseException e) {
            throw new OrekitException(e, (Localizable)new DummyLocalizable(e.getMessage()), new Object[0]);
        }
    }
}

