/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.stat.correlation;

import org.hipparchus.exception.Localizable;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.exception.MathRuntimeException;
import org.hipparchus.linear.MatrixUtils;
import org.hipparchus.linear.RealMatrix;
import org.hipparchus.stat.correlation.Covariance;
import org.hipparchus.stat.correlation.StorelessBivariateCovariance;
import org.hipparchus.util.MathUtils;

public class StorelessCovariance
extends Covariance {
    private final StorelessBivariateCovariance[] covMatrix;
    private final int dimension;

    public StorelessCovariance(int dim) {
        this(dim, true);
    }

    public StorelessCovariance(int dim, boolean biasCorrected) {
        this.dimension = dim;
        this.covMatrix = new StorelessBivariateCovariance[this.dimension * (this.dimension + 1) / 2];
        this.initializeMatrix(biasCorrected);
    }

    private void initializeMatrix(boolean biasCorrected) {
        for (int i = 0; i < this.dimension; ++i) {
            for (int j = 0; j < this.dimension; ++j) {
                this.setElement(i, j, new StorelessBivariateCovariance(biasCorrected));
            }
        }
    }

    private int indexOf(int i, int j) {
        return j < i ? i * (i + 1) / 2 + j : j * (j + 1) / 2 + i;
    }

    private StorelessBivariateCovariance getElement(int i, int j) {
        return this.covMatrix[this.indexOf(i, j)];
    }

    private void setElement(int i, int j, StorelessBivariateCovariance cov) {
        this.covMatrix[this.indexOf((int)i, (int)j)] = cov;
    }

    public double getCovariance(int xIndex, int yIndex) throws MathIllegalArgumentException {
        return this.getElement(xIndex, yIndex).getResult();
    }

    public void increment(double[] data) throws MathIllegalArgumentException {
        int length = data.length;
        MathUtils.checkDimension((int)length, (int)this.dimension);
        for (int i = 0; i < length; ++i) {
            for (int j = i; j < length; ++j) {
                this.getElement(i, j).increment(data[i], data[j]);
            }
        }
    }

    public void append(StorelessCovariance sc) throws MathIllegalArgumentException {
        MathUtils.checkDimension((int)sc.dimension, (int)this.dimension);
        for (int i = 0; i < this.dimension; ++i) {
            for (int j = i; j < this.dimension; ++j) {
                this.getElement(i, j).append(sc.getElement(i, j));
            }
        }
    }

    @Override
    public RealMatrix getCovarianceMatrix() throws MathIllegalArgumentException {
        return MatrixUtils.createRealMatrix((double[][])this.getData());
    }

    public double[][] getData() throws MathIllegalArgumentException {
        double[][] data = new double[this.dimension][this.dimension];
        for (int i = 0; i < this.dimension; ++i) {
            for (int j = 0; j < this.dimension; ++j) {
                data[i][j] = this.getElement(i, j).getResult();
            }
        }
        return data;
    }

    @Override
    public int getN() throws MathRuntimeException {
        throw new MathRuntimeException((Localizable)LocalizedCoreFormats.UNSUPPORTED_OPERATION, new Object[0]);
    }
}

