/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.conversion;

import org.orekit.attitudes.AttitudeProvider;
import org.orekit.attitudes.InertialProvider;
import org.orekit.forces.gravity.potential.GravityFieldFactory;
import org.orekit.forces.gravity.potential.TideSystem;
import org.orekit.forces.gravity.potential.UnnormalizedSphericalHarmonicsProvider;
import org.orekit.orbits.Orbit;
import org.orekit.orbits.OrbitType;
import org.orekit.orbits.PositionAngle;
import org.orekit.propagation.Propagator;
import org.orekit.propagation.analytical.EcksteinHechlerPropagator;
import org.orekit.propagation.conversion.AbstractPropagatorBuilder;

public class EcksteinHechlerPropagatorBuilder
extends AbstractPropagatorBuilder {
    private final UnnormalizedSphericalHarmonicsProvider provider;

    public EcksteinHechlerPropagatorBuilder(Orbit templateOrbit, UnnormalizedSphericalHarmonicsProvider provider, PositionAngle positionAngle, double positionScale) {
        this(templateOrbit, provider, positionAngle, positionScale, InertialProvider.of(templateOrbit.getFrame()));
    }

    public EcksteinHechlerPropagatorBuilder(Orbit templateOrbit, UnnormalizedSphericalHarmonicsProvider provider, PositionAngle positionAngle, double positionScale, AttitudeProvider attitudeProvider) {
        super(EcksteinHechlerPropagatorBuilder.overrideMu(templateOrbit, provider, positionAngle), positionAngle, positionScale, true, attitudeProvider);
        this.provider = provider;
    }

    public EcksteinHechlerPropagatorBuilder(Orbit templateOrbit, double referenceRadius, double mu, TideSystem tideSystem, double c20, double c30, double c40, double c50, double c60, OrbitType orbitType, PositionAngle positionAngle, double positionScale) {
        this(templateOrbit, GravityFieldFactory.getUnnormalizedProvider(referenceRadius, mu, tideSystem, new double[][]{{0.0}, {0.0}, {c20}, {c30}, {c40}, {c50}, {c60}}, new double[][]{{0.0}, {0.0}, {0.0}, {0.0}, {0.0}, {0.0}, {0.0}}), positionAngle, positionScale);
    }

    private static Orbit overrideMu(Orbit templateOrbit, UnnormalizedSphericalHarmonicsProvider provider, PositionAngle positionAngle) {
        double[] parameters = new double[6];
        double[] parametersDot = templateOrbit.hasDerivatives() ? new double[6] : null;
        templateOrbit.getType().mapOrbitToArray(templateOrbit, positionAngle, parameters, parametersDot);
        return templateOrbit.getType().mapArrayToOrbit(parameters, parametersDot, positionAngle, templateOrbit.getDate(), provider.getMu(), templateOrbit.getFrame());
    }

    @Override
    public Propagator buildPropagator(double[] normalizedParameters) {
        this.setParameters(normalizedParameters);
        return new EcksteinHechlerPropagator(this.createInitialOrbit(), this.getAttitudeProvider(), this.provider);
    }
}

