/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.orbits;

import java.io.Serializable;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.linear.DecompositionSolver;
import org.hipparchus.linear.MatrixUtils;
import org.hipparchus.linear.QRDecomposition;
import org.hipparchus.linear.RealMatrix;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.MathArrays;
import org.orekit.errors.OrekitIllegalArgumentException;
import org.orekit.errors.OrekitInternalError;
import org.orekit.errors.OrekitMessages;
import org.orekit.frames.Frame;
import org.orekit.frames.Transform;
import org.orekit.orbits.OrbitType;
import org.orekit.orbits.PositionAngle;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.TimeInterpolable;
import org.orekit.time.TimeShiftable;
import org.orekit.time.TimeStamped;
import org.orekit.utils.PVCoordinates;
import org.orekit.utils.PVCoordinatesProvider;
import org.orekit.utils.TimeStampedPVCoordinates;

public abstract class Orbit
implements TimeStamped,
TimeShiftable<Orbit>,
TimeInterpolable<Orbit>,
Serializable,
PVCoordinatesProvider {
    private static final long serialVersionUID = 438733454597999578L;
    private final Frame frame;
    private final AbsoluteDate date;
    private final double mu;
    private transient TimeStampedPVCoordinates pvCoordinates;
    private transient double[][] jacobianMeanWrtCartesian;
    private transient double[][] jacobianWrtParametersMean;
    private transient double[][] jacobianEccentricWrtCartesian;
    private transient double[][] jacobianWrtParametersEccentric;
    private transient double[][] jacobianTrueWrtCartesian;
    private transient double[][] jacobianWrtParametersTrue;

    protected Orbit(Frame frame, AbsoluteDate date, double mu) throws IllegalArgumentException {
        Orbit.ensurePseudoInertialFrame(frame);
        this.date = date;
        this.mu = mu;
        this.pvCoordinates = null;
        this.frame = frame;
        this.jacobianMeanWrtCartesian = null;
        this.jacobianWrtParametersMean = null;
        this.jacobianEccentricWrtCartesian = null;
        this.jacobianWrtParametersEccentric = null;
        this.jacobianTrueWrtCartesian = null;
        this.jacobianWrtParametersTrue = null;
    }

    protected Orbit(TimeStampedPVCoordinates pvCoordinates, Frame frame, double mu) throws IllegalArgumentException {
        Orbit.ensurePseudoInertialFrame(frame);
        this.date = pvCoordinates.getDate();
        this.mu = mu;
        if (pvCoordinates.getAcceleration().getNormSq() == 0.0) {
            double r2 = pvCoordinates.getPosition().getNormSq();
            double r3 = r2 * FastMath.sqrt((double)r2);
            this.pvCoordinates = new TimeStampedPVCoordinates(pvCoordinates.getDate(), pvCoordinates.getPosition(), pvCoordinates.getVelocity(), new Vector3D(-mu / r3, pvCoordinates.getPosition()));
        } else {
            this.pvCoordinates = pvCoordinates;
        }
        this.frame = frame;
    }

    protected static boolean hasNonKeplerianAcceleration(PVCoordinates pva, double mu) {
        Vector3D a = pva.getAcceleration();
        if (a == null) {
            return false;
        }
        Vector3D p = pva.getPosition();
        double r2 = p.getNormSq();
        double r = FastMath.sqrt((double)r2);
        Vector3D keplerianAcceleration = new Vector3D(-mu / (r * r2), p);
        return a.getNorm() > 1.0E-9 * keplerianAcceleration.getNorm();
    }

    public abstract OrbitType getType();

    private static void ensurePseudoInertialFrame(Frame frame) throws IllegalArgumentException {
        if (!frame.isPseudoInertial()) {
            throw new OrekitIllegalArgumentException(OrekitMessages.NON_PSEUDO_INERTIAL_FRAME, frame.getName());
        }
    }

    public Frame getFrame() {
        return this.frame;
    }

    public abstract double getA();

    public abstract double getADot();

    public abstract double getEquinoctialEx();

    public abstract double getEquinoctialExDot();

    public abstract double getEquinoctialEy();

    public abstract double getEquinoctialEyDot();

    public abstract double getHx();

    public abstract double getHxDot();

    public abstract double getHy();

    public abstract double getHyDot();

    public abstract double getLE();

    public abstract double getLEDot();

    public abstract double getLv();

    public abstract double getLvDot();

    public abstract double getLM();

    public abstract double getLMDot();

    public abstract double getE();

    public abstract double getEDot();

    public abstract double getI();

    public abstract double getIDot();

    public boolean hasDerivatives() {
        return !Double.isNaN(this.getADot());
    }

    public double getMu() {
        return this.mu;
    }

    public double getKeplerianPeriod() {
        double a = this.getA();
        return a < 0.0 ? Double.POSITIVE_INFINITY : Math.PI * 2 * a * FastMath.sqrt((double)(a / this.mu));
    }

    public double getKeplerianMeanMotion() {
        double absA = FastMath.abs((double)this.getA());
        return FastMath.sqrt((double)(this.mu / absA)) / absA;
    }

    @Override
    public AbsoluteDate getDate() {
        return this.date;
    }

    public TimeStampedPVCoordinates getPVCoordinates(Frame outputFrame) {
        if (this.pvCoordinates == null) {
            this.pvCoordinates = this.initPVCoordinates();
        }
        if (outputFrame == this.frame) {
            return this.pvCoordinates;
        }
        Transform t = this.frame.getTransformTo(outputFrame, this.date);
        return t.transformPVCoordinates(this.pvCoordinates);
    }

    @Override
    public TimeStampedPVCoordinates getPVCoordinates(AbsoluteDate otherDate, Frame otherFrame) {
        return this.shiftedBy(otherDate.durationFrom(this.getDate())).getPVCoordinates(otherFrame);
    }

    public TimeStampedPVCoordinates getPVCoordinates() {
        if (this.pvCoordinates == null) {
            this.pvCoordinates = this.initPVCoordinates();
        }
        return this.pvCoordinates;
    }

    protected abstract TimeStampedPVCoordinates initPVCoordinates();

    @Override
    public abstract Orbit shiftedBy(double var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getJacobianWrtCartesian(PositionAngle type, double[][] jacobian) {
        double[][] cachedJacobian;
        Orbit orbit = this;
        synchronized (orbit) {
            switch (type) {
                case MEAN: {
                    if (this.jacobianMeanWrtCartesian == null) {
                        this.jacobianMeanWrtCartesian = this.computeJacobianMeanWrtCartesian();
                    }
                    cachedJacobian = this.jacobianMeanWrtCartesian;
                    break;
                }
                case ECCENTRIC: {
                    if (this.jacobianEccentricWrtCartesian == null) {
                        this.jacobianEccentricWrtCartesian = this.computeJacobianEccentricWrtCartesian();
                    }
                    cachedJacobian = this.jacobianEccentricWrtCartesian;
                    break;
                }
                case TRUE: {
                    if (this.jacobianTrueWrtCartesian == null) {
                        this.jacobianTrueWrtCartesian = this.computeJacobianTrueWrtCartesian();
                    }
                    cachedJacobian = this.jacobianTrueWrtCartesian;
                    break;
                }
                default: {
                    throw new OrekitInternalError(null);
                }
            }
        }
        for (int i = 0; i < cachedJacobian.length; ++i) {
            System.arraycopy(cachedJacobian[i], 0, jacobian[i], 0, cachedJacobian[i].length);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getJacobianWrtParameters(PositionAngle type, double[][] jacobian) {
        double[][] cachedJacobian;
        Orbit orbit = this;
        synchronized (orbit) {
            switch (type) {
                case MEAN: {
                    if (this.jacobianWrtParametersMean == null) {
                        this.jacobianWrtParametersMean = this.createInverseJacobian(type);
                    }
                    cachedJacobian = this.jacobianWrtParametersMean;
                    break;
                }
                case ECCENTRIC: {
                    if (this.jacobianWrtParametersEccentric == null) {
                        this.jacobianWrtParametersEccentric = this.createInverseJacobian(type);
                    }
                    cachedJacobian = this.jacobianWrtParametersEccentric;
                    break;
                }
                case TRUE: {
                    if (this.jacobianWrtParametersTrue == null) {
                        this.jacobianWrtParametersTrue = this.createInverseJacobian(type);
                    }
                    cachedJacobian = this.jacobianWrtParametersTrue;
                    break;
                }
                default: {
                    throw new OrekitInternalError(null);
                }
            }
        }
        for (int i = 0; i < cachedJacobian.length; ++i) {
            System.arraycopy(cachedJacobian[i], 0, jacobian[i], 0, cachedJacobian[i].length);
        }
    }

    private double[][] createInverseJacobian(PositionAngle type) {
        double[][] directJacobian = new double[6][6];
        this.getJacobianWrtCartesian(type, directJacobian);
        RealMatrix matrix = MatrixUtils.createRealMatrix((double[][])directJacobian);
        DecompositionSolver solver = new QRDecomposition(matrix).getSolver();
        return solver.getInverse().getData();
    }

    protected abstract double[][] computeJacobianMeanWrtCartesian();

    protected abstract double[][] computeJacobianEccentricWrtCartesian();

    protected abstract double[][] computeJacobianTrueWrtCartesian();

    public abstract void addKeplerContribution(PositionAngle var1, double var2, double[] var4);

    protected static void fillHalfRow(double a, Vector3D v, double[] row, int j) {
        row[j] = a * v.getX();
        row[j + 1] = a * v.getY();
        row[j + 2] = a * v.getZ();
    }

    protected static void fillHalfRow(double a1, Vector3D v1, double a2, Vector3D v2, double[] row, int j) {
        row[j] = MathArrays.linearCombination((double)a1, (double)v1.getX(), (double)a2, (double)v2.getX());
        row[j + 1] = MathArrays.linearCombination((double)a1, (double)v1.getY(), (double)a2, (double)v2.getY());
        row[j + 2] = MathArrays.linearCombination((double)a1, (double)v1.getZ(), (double)a2, (double)v2.getZ());
    }

    protected static void fillHalfRow(double a1, Vector3D v1, double a2, Vector3D v2, double a3, Vector3D v3, double[] row, int j) {
        row[j] = MathArrays.linearCombination((double)a1, (double)v1.getX(), (double)a2, (double)v2.getX(), (double)a3, (double)v3.getX());
        row[j + 1] = MathArrays.linearCombination((double)a1, (double)v1.getY(), (double)a2, (double)v2.getY(), (double)a3, (double)v3.getY());
        row[j + 2] = MathArrays.linearCombination((double)a1, (double)v1.getZ(), (double)a2, (double)v2.getZ(), (double)a3, (double)v3.getZ());
    }

    protected static void fillHalfRow(double a1, Vector3D v1, double a2, Vector3D v2, double a3, Vector3D v3, double a4, Vector3D v4, double[] row, int j) {
        row[j] = MathArrays.linearCombination((double)a1, (double)v1.getX(), (double)a2, (double)v2.getX(), (double)a3, (double)v3.getX(), (double)a4, (double)v4.getX());
        row[j + 1] = MathArrays.linearCombination((double)a1, (double)v1.getY(), (double)a2, (double)v2.getY(), (double)a3, (double)v3.getY(), (double)a4, (double)v4.getY());
        row[j + 2] = MathArrays.linearCombination((double)a1, (double)v1.getZ(), (double)a2, (double)v2.getZ(), (double)a3, (double)v3.getZ(), (double)a4, (double)v4.getZ());
    }

    protected static void fillHalfRow(double a1, Vector3D v1, double a2, Vector3D v2, double a3, Vector3D v3, double a4, Vector3D v4, double a5, Vector3D v5, double[] row, int j) {
        double[] a = new double[]{a1, a2, a3, a4, a5};
        row[j] = MathArrays.linearCombination((double[])a, (double[])new double[]{v1.getX(), v2.getX(), v3.getX(), v4.getX(), v5.getX()});
        row[j + 1] = MathArrays.linearCombination((double[])a, (double[])new double[]{v1.getY(), v2.getY(), v3.getY(), v4.getY(), v5.getY()});
        row[j + 2] = MathArrays.linearCombination((double[])a, (double[])new double[]{v1.getZ(), v2.getZ(), v3.getZ(), v4.getZ(), v5.getZ()});
    }

    protected static void fillHalfRow(double a1, Vector3D v1, double a2, Vector3D v2, double a3, Vector3D v3, double a4, Vector3D v4, double a5, Vector3D v5, double a6, Vector3D v6, double[] row, int j) {
        double[] a = new double[]{a1, a2, a3, a4, a5, a6};
        row[j] = MathArrays.linearCombination((double[])a, (double[])new double[]{v1.getX(), v2.getX(), v3.getX(), v4.getX(), v5.getX(), v6.getX()});
        row[j + 1] = MathArrays.linearCombination((double[])a, (double[])new double[]{v1.getY(), v2.getY(), v3.getY(), v4.getY(), v5.getY(), v6.getY()});
        row[j + 2] = MathArrays.linearCombination((double[])a, (double[])new double[]{v1.getZ(), v2.getZ(), v3.getZ(), v4.getZ(), v5.getZ(), v6.getZ()});
    }
}

