/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.attitudes;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.FieldElement;
import org.hipparchus.exception.Localizable;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.util.FastMath;
import org.orekit.attitudes.Attitude;
import org.orekit.attitudes.AttitudeProvider;
import org.orekit.attitudes.FieldAttitude;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.frames.Frame;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.utils.AngularCoordinates;
import org.orekit.utils.FieldAngularCoordinates;
import org.orekit.utils.FieldPVCoordinates;
import org.orekit.utils.FieldPVCoordinatesProvider;
import org.orekit.utils.PVCoordinates;
import org.orekit.utils.PVCoordinatesProvider;
import org.orekit.utils.TimeStampedFieldPVCoordinates;
import org.orekit.utils.TimeStampedPVCoordinates;

public abstract class GroundPointing
implements AttitudeProvider {
    private static final PVCoordinates PLUS_J = new PVCoordinates(Vector3D.PLUS_J, Vector3D.ZERO, Vector3D.ZERO);
    private static final PVCoordinates PLUS_K = new PVCoordinates(Vector3D.PLUS_K, Vector3D.ZERO, Vector3D.ZERO);
    private final Frame inertialFrame;
    private final Frame bodyFrame;

    protected GroundPointing(Frame inertialFrame, Frame bodyFrame) {
        if (!inertialFrame.isPseudoInertial()) {
            throw new OrekitException((Localizable)OrekitMessages.NON_PSEUDO_INERTIAL_FRAME, inertialFrame.getName());
        }
        this.inertialFrame = inertialFrame;
        this.bodyFrame = bodyFrame;
    }

    public Frame getBodyFrame() {
        return this.bodyFrame;
    }

    public abstract TimeStampedPVCoordinates getTargetPV(PVCoordinatesProvider var1, AbsoluteDate var2, Frame var3);

    public abstract <T extends CalculusFieldElement<T>> TimeStampedFieldPVCoordinates<T> getTargetPV(FieldPVCoordinatesProvider<T> var1, FieldAbsoluteDate<T> var2, Frame var3);

    @Override
    public Attitude getAttitude(PVCoordinatesProvider pvProv, AbsoluteDate date, Frame frame) {
        TimeStampedPVCoordinates pva = pvProv.getPVCoordinates(date, this.inertialFrame);
        TimeStampedPVCoordinates delta = new TimeStampedPVCoordinates(date, pva, (PVCoordinates)this.getTargetPV(pvProv, date, this.inertialFrame));
        if (delta.getPosition().getNorm() == 0.0) {
            throw new OrekitException((Localizable)OrekitMessages.SATELLITE_COLLIDED_WITH_TARGET, new Object[0]);
        }
        Vector3D p = pva.getPosition();
        Vector3D v = pva.getVelocity();
        Vector3D a = pva.getAcceleration();
        double r2 = p.getNormSq();
        double r = FastMath.sqrt((double)r2);
        Vector3D keplerianJerk = new Vector3D(-3.0 * Vector3D.dotProduct((Vector3D)p, (Vector3D)v) / r2, a, -a.getNorm() / r, v);
        PVCoordinates velocity = new PVCoordinates(v, a, keplerianJerk);
        PVCoordinates los = delta.normalize();
        PVCoordinates normal = PVCoordinates.crossProduct(delta, velocity).normalize();
        AngularCoordinates ac = new AngularCoordinates(los, normal, PLUS_K, PLUS_J, 1.0E-9);
        if (frame != this.inertialFrame) {
            ac = ac.addOffset(frame.getTransformTo(this.inertialFrame, date).getAngular());
        }
        return new Attitude(date, frame, ac);
    }

    @Override
    public <T extends CalculusFieldElement<T>> FieldAttitude<T> getAttitude(FieldPVCoordinatesProvider<T> pvProv, FieldAbsoluteDate<T> date, Frame frame) {
        TimeStampedFieldPVCoordinates<T> pva = pvProv.getPVCoordinates(date, this.inertialFrame);
        TimeStampedFieldPVCoordinates delta = new TimeStampedFieldPVCoordinates(date, pva, this.getTargetPV(pvProv, date, this.inertialFrame));
        if (delta.getPosition().getNorm().getReal() == 0.0) {
            throw new OrekitException((Localizable)OrekitMessages.SATELLITE_COLLIDED_WITH_TARGET, new Object[0]);
        }
        FieldVector3D p = pva.getPosition();
        FieldVector3D v = pva.getVelocity();
        FieldVector3D a = pva.getAcceleration();
        CalculusFieldElement r2 = p.getNormSq();
        CalculusFieldElement r = (CalculusFieldElement)r2.sqrt();
        FieldVector3D keplerianJerk = new FieldVector3D((CalculusFieldElement)((CalculusFieldElement)FieldVector3D.dotProduct(p, v).multiply(-3)).divide((FieldElement)r2), a, (CalculusFieldElement)((CalculusFieldElement)a.getNorm().divide((FieldElement)r)).multiply(-1), v);
        FieldPVCoordinates velocity = new FieldPVCoordinates(v, a, keplerianJerk);
        FieldPVCoordinates los = delta.normalize();
        FieldPVCoordinates normal = delta.crossProduct(velocity).normalize();
        FieldVector3D zero = FieldVector3D.getZero((Field)r.getField());
        FieldVector3D plusK = FieldVector3D.getPlusK((Field)r.getField());
        FieldVector3D plusJ = FieldVector3D.getPlusJ((Field)r.getField());
        FieldAngularCoordinates ac = new FieldAngularCoordinates(los, normal, new FieldPVCoordinates(plusK, zero, zero), new FieldPVCoordinates(plusJ, zero, zero), 1.0E-6);
        if (frame != this.inertialFrame) {
            ac = ac.addOffset(new FieldAngularCoordinates(r.getField(), frame.getTransformTo(this.inertialFrame, date.toAbsoluteDate()).getAngular()));
        }
        return new FieldAttitude<T>(date, frame, ac);
    }
}

