/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.events;

import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.util.FastMath;
import org.orekit.frames.Frame;
import org.orekit.frames.TopocentricFrame;
import org.orekit.models.AtmosphericRefractionModel;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.events.AbstractDetector;
import org.orekit.propagation.events.handlers.ContinueOnEvent;
import org.orekit.propagation.events.handlers.EventHandler;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.PVCoordinatesProvider;

public class GroundAtNightDetector
extends AbstractDetector<GroundAtNightDetector> {
    public static final double CIVIL_DAWN_DUSK_ELEVATION = FastMath.toRadians((double)-6.0);
    public static final double NAUTICAL_DAWN_DUSK_ELEVATION = FastMath.toRadians((double)-12.0);
    public static final double ASTRONOMICAL_DAWN_DUSK_ELEVATION = FastMath.toRadians((double)-18.0);
    private final TopocentricFrame groundLocation;
    private final PVCoordinatesProvider sun;
    private final double dawnDuskElevation;
    private final AtmosphericRefractionModel refractionModel;

    public GroundAtNightDetector(TopocentricFrame groundLocation, PVCoordinatesProvider sun, double dawnDuskElevation, AtmosphericRefractionModel refractionModel) {
        this(groundLocation, sun, dawnDuskElevation, refractionModel, 600.0, 1.0E-6, 100, new ContinueOnEvent());
    }

    private GroundAtNightDetector(TopocentricFrame groundLocation, PVCoordinatesProvider sun, double dawnDuskElevation, AtmosphericRefractionModel refractionModel, double maxCheck, double threshold, int maxIter, EventHandler<? super GroundAtNightDetector> handler) {
        super(maxCheck, threshold, maxIter, handler);
        this.groundLocation = groundLocation;
        this.sun = sun;
        this.dawnDuskElevation = dawnDuskElevation;
        this.refractionModel = refractionModel;
    }

    @Override
    protected GroundAtNightDetector create(double newMaxCheck, double newThreshold, int newMaxIter, EventHandler<? super GroundAtNightDetector> newHandler) {
        return new GroundAtNightDetector(this.groundLocation, this.sun, this.dawnDuskElevation, this.refractionModel, newMaxCheck, newThreshold, newMaxIter, newHandler);
    }

    @Override
    public double g(SpacecraftState state) {
        AbsoluteDate date = state.getDate();
        Frame frame = state.getFrame();
        Vector3D position = this.sun.getPVCoordinates(date, frame).getPosition();
        double trueElevation = this.groundLocation.getElevation(position, frame, date);
        double calculatedElevation = this.refractionModel != null ? trueElevation + this.refractionModel.getRefraction(trueElevation) : trueElevation;
        return this.dawnDuskElevation - calculatedElevation;
    }
}

