/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.models.earth.troposphere;

import java.util.List;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.util.MathArrays;
import org.orekit.bodies.FieldGeodeticPoint;
import org.orekit.bodies.GeodeticPoint;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.utils.ParameterDriver;

public interface DiscreteTroposphericModel {
    public double pathDelay(double var1, GeodeticPoint var3, double[] var4, AbsoluteDate var5);

    public <T extends CalculusFieldElement<T>> T pathDelay(T var1, FieldGeodeticPoint<T> var2, T[] var3, FieldAbsoluteDate<T> var4);

    public List<ParameterDriver> getParametersDrivers();

    default public double[] getParameters() {
        List<ParameterDriver> drivers = this.getParametersDrivers();
        double[] parameters = new double[drivers.size()];
        for (int i = 0; i < drivers.size(); ++i) {
            parameters[i] = drivers.get(i).getValue();
        }
        return parameters;
    }

    default public <T extends CalculusFieldElement<T>> T[] getParameters(Field<T> field) {
        List<ParameterDriver> drivers = this.getParametersDrivers();
        CalculusFieldElement[] parameters = (CalculusFieldElement[])MathArrays.buildArray(field, (int)drivers.size());
        for (int i = 0; i < drivers.size(); ++i) {
            parameters[i] = (CalculusFieldElement)((CalculusFieldElement)field.getZero()).add(drivers.get(i).getValue());
        }
        return parameters;
    }
}

