/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds.ndm.odm.omm;

import org.orekit.files.ccsds.ndm.odm.omm.OmmTleKey;
import org.orekit.files.ccsds.section.CommentsContainer;

public class OmmTle
extends CommentsContainer {
    private int ephemerisType = 0;
    private char classificationType = (char)85;
    private int noradID = -1;
    private int elementSetNo = -1;
    private int revAtEpoch = -1;
    private double bStar = Double.NaN;
    private double meanMotionDot = Double.NaN;
    private double meanMotionDotDot = Double.NaN;

    @Override
    public void validate(double version) {
        super.validate(version);
        this.checkNotNaN(this.meanMotionDot, OmmTleKey.MEAN_MOTION_DOT);
        this.checkNotNaN(this.meanMotionDotDot, OmmTleKey.MEAN_MOTION_DDOT);
        this.checkNotNegative(this.noradID, OmmTleKey.NORAD_CAT_ID);
        this.checkNotNegative(this.elementSetNo, OmmTleKey.ELEMENT_SET_NO);
        this.checkNotNegative(this.revAtEpoch, OmmTleKey.REV_AT_EPOCH);
    }

    public int getEphemerisType() {
        return this.ephemerisType;
    }

    public void setEphemerisType(int ephemerisType) {
        this.refuseFurtherComments();
        this.ephemerisType = ephemerisType;
    }

    public char getClassificationType() {
        return this.classificationType;
    }

    public void setClassificationType(char classificationType) {
        this.refuseFurtherComments();
        this.classificationType = classificationType;
    }

    public int getNoradID() {
        return this.noradID;
    }

    public void setNoradID(int noradID) {
        this.refuseFurtherComments();
        this.noradID = noradID;
    }

    public int getElementSetNumber() {
        return this.elementSetNo;
    }

    public void setElementSetNo(int elementSetNo) {
        this.refuseFurtherComments();
        this.elementSetNo = elementSetNo;
    }

    public int getRevAtEpoch() {
        return this.revAtEpoch;
    }

    public void setRevAtEpoch(int revAtEpoch) {
        this.refuseFurtherComments();
        this.revAtEpoch = revAtEpoch;
    }

    public double getBStar() {
        return this.bStar;
    }

    public void setBStar(double bstar) {
        this.refuseFurtherComments();
        this.bStar = bstar;
    }

    public double getMeanMotionDot() {
        return this.meanMotionDot;
    }

    public void setMeanMotionDot(double meanMotionDot) {
        this.refuseFurtherComments();
        this.meanMotionDot = meanMotionDot;
    }

    public double getMeanMotionDotDot() {
        return this.meanMotionDotDot;
    }

    public void setMeanMotionDotDot(double meanMotionDotDot) {
        this.refuseFurtherComments();
        this.meanMotionDotDot = meanMotionDotDot;
    }
}

