/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds.definitions;

import org.hipparchus.exception.Localizable;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.files.ccsds.definitions.TimeConverter;
import org.orekit.files.ccsds.utils.ContextBinding;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.SatelliteClockScale;

public enum TimeSystem {
    GMST{

        @Override
        public TimeConverter getConverter(ContextBinding context) {
            return new TimeConverter(context.getDataContext().getTimeScales().getGMST(context.getConventions(), false), context.getReferenceDate());
        }
    }
    ,
    GPS{

        @Override
        public TimeConverter getConverter(ContextBinding context) {
            return new TimeConverter(context.getDataContext().getTimeScales().getGPS(), context.getReferenceDate());
        }
    }
    ,
    MET{

        @Override
        public TimeConverter getConverter(ContextBinding context) {
            return new TimeConverter(new SatelliteClockScale("MET", context.getReferenceDate(), context.getDataContext().getTimeScales().getUTC(), 0.0, 0.0), context.getReferenceDate());
        }
    }
    ,
    MRT{

        @Override
        public TimeConverter getConverter(ContextBinding context) {
            return new TimeConverter(new SatelliteClockScale("MRT", context.getReferenceDate(), context.getDataContext().getTimeScales().getUTC(), 0.0, 0.0), context.getReferenceDate());
        }
    }
    ,
    SCLK{

        @Override
        public TimeConverter getConverter(ContextBinding context) {
            return new TimeConverter(new SatelliteClockScale("SCLK", context.getReferenceDate(), context.getDataContext().getTimeScales().getUTC(), context.getClockCount(), context.getClockRate() - 1.0), context.getReferenceDate()){

                @Override
                public double offset(AbsoluteDate date) {
                    return ((SatelliteClockScale)this.getTimeScale()).countAtDate(date);
                }
            };
        }
    }
    ,
    TAI{

        @Override
        public TimeConverter getConverter(ContextBinding context) {
            return new TimeConverter(context.getDataContext().getTimeScales().getTAI(), context.getReferenceDate());
        }
    }
    ,
    TCB{

        @Override
        public TimeConverter getConverter(ContextBinding context) {
            return new TimeConverter(context.getDataContext().getTimeScales().getTCB(), context.getReferenceDate());
        }
    }
    ,
    TDB{

        @Override
        public TimeConverter getConverter(ContextBinding context) {
            return new TimeConverter(context.getDataContext().getTimeScales().getTDB(), context.getReferenceDate());
        }
    }
    ,
    TCG{

        @Override
        public TimeConverter getConverter(ContextBinding context) {
            return new TimeConverter(context.getDataContext().getTimeScales().getTCG(), context.getReferenceDate());
        }
    }
    ,
    TT{

        @Override
        public TimeConverter getConverter(ContextBinding context) {
            return new TimeConverter(context.getDataContext().getTimeScales().getTT(), context.getReferenceDate());
        }
    }
    ,
    UT1{

        @Override
        public TimeConverter getConverter(ContextBinding context) {
            return new TimeConverter(context.getDataContext().getTimeScales().getUT1(context.getConventions(), false), context.getReferenceDate());
        }
    }
    ,
    UTC{

        @Override
        public TimeConverter getConverter(ContextBinding context) {
            return new TimeConverter(context.getDataContext().getTimeScales().getUTC(), context.getReferenceDate());
        }
    };


    public abstract TimeConverter getConverter(ContextBinding var1);

    public static TimeSystem parse(String value) {
        for (TimeSystem scale : TimeSystem.values()) {
            if (!scale.name().equals(value)) continue;
            return scale;
        }
        throw new OrekitException((Localizable)OrekitMessages.CCSDS_TIME_SYSTEM_NOT_IMPLEMENTED, value);
    }
}

