/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.bodies;

import org.orekit.annotation.DefaultDataContext;
import org.orekit.bodies.CR3BPSystem;
import org.orekit.bodies.CelestialBody;
import org.orekit.bodies.CelestialBodyFactory;
import org.orekit.propagation.numerical.cr3bp.CR3BPConstants;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.TimeScale;

public class CR3BPFactory {
    private CR3BPFactory() {
    }

    @DefaultDataContext
    public static CR3BPSystem getSunJupiterCR3BP(AbsoluteDate date, TimeScale timeScale) {
        return CR3BPFactory.getSystem(CelestialBodyFactory.getSun(), CelestialBodyFactory.getJupiter(), CR3BPConstants.getJupiterSemiMajorAxis(date, timeScale));
    }

    @DefaultDataContext
    public static CR3BPSystem getSunEarthCR3BP(AbsoluteDate date, TimeScale timeScale) {
        return CR3BPFactory.getSystem(CelestialBodyFactory.getSun(), CelestialBodyFactory.getEarthMoonBarycenter(), CR3BPConstants.getEarthMoonBarycenterSemiMajorAxis(date, timeScale));
    }

    @DefaultDataContext
    public static CR3BPSystem getEarthMoonCR3BP() {
        return CR3BPFactory.getSystem(CelestialBodyFactory.getEarth(), CelestialBodyFactory.getMoon(), CR3BPConstants.getMoonSemiMajorAxis());
    }

    public static CR3BPSystem getSystem(CelestialBody primaryBody, CelestialBody secondaryBody, double a) {
        return new CR3BPSystem(primaryBody, secondaryBody, a);
    }
}

