/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.models.earth.troposphere;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.FieldElement;
import org.hipparchus.util.FastMath;

public class TroposphericModelUtils {
    private TroposphericModelUtils() {
    }

    public static double mappingFunction(double a, double b, double c, double elevation) {
        double sinE = FastMath.sin((double)elevation);
        double numMP = 1.0 + a / (1.0 + b / (1.0 + c));
        double denMP = sinE + a / (sinE + b / (sinE + c));
        double fElevation = numMP / denMP;
        return fElevation;
    }

    public static <T extends CalculusFieldElement<T>> T mappingFunction(T a, T b, T c, T elevation) {
        CalculusFieldElement sinE = FastMath.sin(elevation);
        CalculusFieldElement numMP = (CalculusFieldElement)((CalculusFieldElement)a.divide((FieldElement)((CalculusFieldElement)((CalculusFieldElement)b.divide((FieldElement)((CalculusFieldElement)c.add(1.0)))).add(1.0)))).add(1.0);
        CalculusFieldElement denMP = (CalculusFieldElement)((CalculusFieldElement)a.divide((FieldElement)((CalculusFieldElement)((CalculusFieldElement)b.divide((FieldElement)((CalculusFieldElement)c.add((FieldElement)sinE)))).add((FieldElement)sinE)))).add((FieldElement)sinE);
        CalculusFieldElement fElevation = (CalculusFieldElement)numMP.divide((FieldElement)denMP);
        return (T)fElevation;
    }

    public static double computeHeightCorrection(double elevation, double height) {
        double fixedHeight = FastMath.max((double)0.0, (double)height);
        double sinE = FastMath.sin((double)elevation);
        double function = TroposphericModelUtils.mappingFunction(2.53E-5, 0.00549, 0.00114, elevation);
        double dmdh = 1.0 / sinE - function;
        double correction = dmdh * (fixedHeight / 1000.0);
        return correction;
    }

    public static <T extends CalculusFieldElement<T>> T computeHeightCorrection(T elevation, T height, Field<T> field) {
        CalculusFieldElement zero = (CalculusFieldElement)field.getZero();
        CalculusFieldElement fixedHeight = FastMath.max((CalculusFieldElement)zero, height);
        CalculusFieldElement sinE = FastMath.sin(elevation);
        CalculusFieldElement function = TroposphericModelUtils.mappingFunction((CalculusFieldElement)zero.add(2.53E-5), (CalculusFieldElement)zero.add(0.00549), (CalculusFieldElement)zero.add(0.00114), elevation);
        CalculusFieldElement dmdh = (CalculusFieldElement)((CalculusFieldElement)sinE.reciprocal()).subtract((FieldElement)function);
        CalculusFieldElement correction = (CalculusFieldElement)dmdh.multiply((FieldElement)((CalculusFieldElement)fixedHeight.divide(1000.0)));
        return (T)correction;
    }
}

