/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.frames;

import java.io.Serializable;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.FieldElement;
import org.hipparchus.geometry.euclidean.threed.FieldRotation;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Rotation;
import org.hipparchus.geometry.euclidean.threed.RotationConvention;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.util.FastMath;
import org.orekit.annotation.DefaultDataContext;
import org.orekit.data.DataContext;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitInternalError;
import org.orekit.frames.EOPBasedTransformProvider;
import org.orekit.frames.EOPHistory;
import org.orekit.frames.FieldTransform;
import org.orekit.frames.Transform;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.time.TimeScalarFunction;
import org.orekit.time.TimeScales;
import org.orekit.time.TimeVectorFunction;
import org.orekit.utils.IERSConventions;

class TEMEProvider
implements EOPBasedTransformProvider {
    private static final long serialVersionUID = 20131209L;
    private final IERSConventions conventions;
    private final EOPHistory eopHistory;
    private final transient TimeScalarFunction obliquityFunction;
    private final transient TimeVectorFunction nutationFunction;

    TEMEProvider(IERSConventions conventions, EOPHistory eopHistory, TimeScales timeScales) {
        this.conventions = conventions;
        this.eopHistory = eopHistory;
        this.obliquityFunction = conventions.getMeanObliquityFunction(timeScales);
        this.nutationFunction = conventions.getNutationFunction(timeScales);
    }

    private TEMEProvider(IERSConventions conventions, EOPHistory eopHistory, TimeScalarFunction obliquityFunction, TimeVectorFunction nutationFunction) {
        this.conventions = conventions;
        this.eopHistory = eopHistory;
        this.obliquityFunction = obliquityFunction;
        this.nutationFunction = nutationFunction;
    }

    @Override
    public EOPHistory getEOPHistory() {
        return this.eopHistory;
    }

    @Override
    public TEMEProvider getNonInterpolatingProvider() {
        return new TEMEProvider(this.conventions, this.eopHistory.getNonInterpolatingEOPHistory(), this.obliquityFunction, this.nutationFunction);
    }

    @Override
    public Transform getTransform(AbsoluteDate date) {
        double eqe = this.getEquationOfEquinoxes(date);
        return new Transform(date, new Rotation(Vector3D.PLUS_K, eqe, RotationConvention.FRAME_TRANSFORM));
    }

    @Override
    public <T extends CalculusFieldElement<T>> FieldTransform<T> getTransform(FieldAbsoluteDate<T> date) {
        T eqe = this.getEquationOfEquinoxes(date);
        return new FieldTransform<T>(date, new FieldRotation(FieldVector3D.getPlusK(date.getField()), eqe, RotationConvention.FRAME_TRANSFORM));
    }

    private double getEquationOfEquinoxes(AbsoluteDate date) {
        double[] angles = this.nutationFunction.value(date);
        double dPsi = angles[0];
        if (this.eopHistory != null) {
            double[] correction = this.eopHistory.getEquinoxNutationCorrection(date);
            dPsi += correction[0];
        }
        double moe = this.obliquityFunction.value(date);
        double eqe = dPsi * FastMath.cos((double)moe);
        return eqe + angles[2];
    }

    private <T extends CalculusFieldElement<T>> T getEquationOfEquinoxes(FieldAbsoluteDate<T> date) {
        CalculusFieldElement[] angles = this.nutationFunction.value(date);
        CalculusFieldElement dPsi = angles[0];
        if (this.eopHistory != null) {
            CalculusFieldElement[] correction = this.eopHistory.getEquinoxNutationCorrection(date);
            dPsi = (CalculusFieldElement)dPsi.add((FieldElement)correction[0]);
        }
        T moe = this.obliquityFunction.value(date);
        CalculusFieldElement eqe = (CalculusFieldElement)dPsi.multiply((FieldElement)((CalculusFieldElement)moe.cos()));
        return (T)((CalculusFieldElement)eqe.add((FieldElement)angles[2]));
    }

    @DefaultDataContext
    private Object writeReplace() {
        return new DataTransferObject(this.conventions, this.eopHistory);
    }

    @DefaultDataContext
    private static class DataTransferObject
    implements Serializable {
        private static final long serialVersionUID = 20131209L;
        private final IERSConventions conventions;
        private final EOPHistory eopHistory;

        DataTransferObject(IERSConventions conventions, EOPHistory eopHistory) {
            this.conventions = conventions;
            this.eopHistory = eopHistory;
        }

        private Object readResolve() {
            try {
                return new TEMEProvider(this.conventions, this.eopHistory, DataContext.getDefault().getTimeScales());
            }
            catch (OrekitException oe) {
                throw new OrekitInternalError(oe);
            }
        }
    }
}

