/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ilrs;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.orekit.files.general.EphemerisFile;
import org.orekit.files.ilrs.CPFHeader;
import org.orekit.frames.Frame;
import org.orekit.propagation.BoundedPropagator;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.TimeScale;
import org.orekit.utils.CartesianDerivativesFilter;
import org.orekit.utils.TimeStampedPVCoordinates;

public class CPF
implements EphemerisFile<CPFCoordinate, CPFEphemeris> {
    private double mu = Double.NaN;
    private int interpolationSample;
    private TimeScale timeScale;
    private CartesianDerivativesFilter filter;
    private CPFHeader header;
    private CPFEphemeris ephemeris = new CPFEphemeris();
    private List<String> comments;

    public CPF() {
        this.header = new CPFHeader();
        this.comments = new ArrayList<String>();
    }

    @Override
    public Map<String, CPFEphemeris> getSatellites() {
        HashMap<String, CPFEphemeris> satellites = new HashMap<String, CPFEphemeris>();
        satellites.put(this.ephemeris.getId(), this.ephemeris);
        return Collections.unmodifiableMap(satellites);
    }

    public CPFHeader getHeader() {
        return this.header;
    }

    public TimeScale getTimeScale() {
        return this.timeScale;
    }

    public List<String> getComments() {
        return this.comments;
    }

    public void addSatelliteCoordinate(CPFCoordinate coord) {
        this.ephemeris.coordinates.add(coord);
    }

    public void setInterpolationSample(int interpolationSample) {
        this.interpolationSample = interpolationSample;
    }

    public void setMu(double mu) {
        this.mu = mu;
    }

    public void setTimeScale(TimeScale timeScale) {
        this.timeScale = timeScale;
    }

    public void setFilter(CartesianDerivativesFilter filter) {
        this.filter = filter;
    }

    public static class CPFCoordinate
    extends TimeStampedPVCoordinates {
        private static final long serialVersionUID = 20201016L;
        private final int leap;

        public CPFCoordinate(AbsoluteDate date, Vector3D position, int leap) {
            this(date, position, Vector3D.ZERO, leap);
        }

        public CPFCoordinate(AbsoluteDate date, Vector3D position, Vector3D velocity, int leap) {
            super(date, position, velocity);
            this.leap = leap;
        }

        public int getLeap() {
            return this.leap;
        }
    }

    public class CPFEphemeris
    implements EphemerisFile.SatelliteEphemeris<CPFCoordinate, CPFEphemeris>,
    EphemerisFile.EphemerisSegment<CPFCoordinate> {
        private final List<CPFCoordinate> coordinates = new ArrayList<CPFCoordinate>();

        @Override
        public Frame getFrame() {
            return CPF.this.header.getRefFrame();
        }

        @Override
        public int getInterpolationSamples() {
            return CPF.this.interpolationSample;
        }

        @Override
        public CartesianDerivativesFilter getAvailableDerivatives() {
            return CPF.this.filter;
        }

        @Override
        public List<CPFCoordinate> getCoordinates() {
            return Collections.unmodifiableList(this.coordinates);
        }

        @Override
        public String getId() {
            return CPF.this.header.getIlrsSatelliteId();
        }

        @Override
        public double getMu() {
            return CPF.this.mu;
        }

        @Override
        public List<CPFEphemeris> getSegments() {
            return Collections.singletonList(this);
        }

        @Override
        public AbsoluteDate getStart() {
            return this.coordinates.get(0).getDate();
        }

        @Override
        public AbsoluteDate getStop() {
            return this.coordinates.get(this.coordinates.size() - 1).getDate();
        }

        @Override
        public BoundedPropagator getPropagator() {
            return EphemerisFile.EphemerisSegment.super.getPropagator();
        }

        public List<CPFCoordinate> getEphemeridesDataLines() {
            return this.coordinates;
        }
    }
}

