/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.data;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.FieldElement;
import org.orekit.data.BodiesElements;
import org.orekit.data.FieldBodiesElements;
import org.orekit.data.SeriesTerm;

class PlanetaryTerm
extends SeriesTerm {
    private final int cMe;
    private final int cVe;
    private final int cE;
    private final int cMa;
    private final int cJu;
    private final int cSa;
    private final int cUr;
    private final int cNe;
    private final int cPa;

    PlanetaryTerm(int cMe, int cVe, int cE, int cMa, int cJu, int cSa, int cUr, int cNe, int cPa) {
        this.cMe = cMe;
        this.cVe = cVe;
        this.cE = cE;
        this.cMa = cMa;
        this.cJu = cJu;
        this.cSa = cSa;
        this.cUr = cUr;
        this.cNe = cNe;
        this.cPa = cPa;
    }

    @Override
    protected double argument(BodiesElements elements) {
        return (double)this.cMe * elements.getLMe() + (double)this.cVe * elements.getLVe() + (double)this.cE * elements.getLE() + (double)this.cMa * elements.getLMa() + (double)this.cJu * elements.getLJu() + (double)this.cSa * elements.getLSa() + (double)this.cUr * elements.getLUr() + (double)this.cNe * elements.getLNe() + (double)this.cPa * elements.getPa();
    }

    @Override
    protected double argumentDerivative(BodiesElements elements) {
        return (double)this.cMe * elements.getLMeDot() + (double)this.cVe * elements.getLVeDot() + (double)this.cE * elements.getLEDot() + (double)this.cMa * elements.getLMaDot() + (double)this.cJu * elements.getLJuDot() + (double)this.cSa * elements.getLSaDot() + (double)this.cUr * elements.getLUrDot() + (double)this.cNe * elements.getLNeDot() + (double)this.cPa * elements.getPaDot();
    }

    @Override
    protected <T extends CalculusFieldElement<T>> T argument(FieldBodiesElements<T> elements) {
        return (T)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)elements.getLMe().multiply(this.cMe)).add((FieldElement)((CalculusFieldElement)elements.getLVe().multiply(this.cVe)))).add((FieldElement)((CalculusFieldElement)elements.getLE().multiply(this.cE)))).add((FieldElement)((CalculusFieldElement)elements.getLMa().multiply(this.cMa)))).add((FieldElement)((CalculusFieldElement)elements.getLJu().multiply(this.cJu)))).add((FieldElement)((CalculusFieldElement)elements.getLSa().multiply(this.cSa)))).add((FieldElement)((CalculusFieldElement)elements.getLUr().multiply(this.cUr)))).add((FieldElement)((CalculusFieldElement)elements.getLNe().multiply(this.cNe)))).add((FieldElement)((CalculusFieldElement)elements.getPa().multiply(this.cPa))));
    }

    @Override
    protected <T extends CalculusFieldElement<T>> T argumentDerivative(FieldBodiesElements<T> elements) {
        return (T)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)elements.getLMeDot().multiply(this.cMe)).add((FieldElement)((CalculusFieldElement)elements.getLVeDot().multiply(this.cVe)))).add((FieldElement)((CalculusFieldElement)elements.getLEDot().multiply(this.cE)))).add((FieldElement)((CalculusFieldElement)elements.getLMaDot().multiply(this.cMa)))).add((FieldElement)((CalculusFieldElement)elements.getLJuDot().multiply(this.cJu)))).add((FieldElement)((CalculusFieldElement)elements.getLSaDot().multiply(this.cSa)))).add((FieldElement)((CalculusFieldElement)elements.getLUrDot().multiply(this.cUr)))).add((FieldElement)((CalculusFieldElement)elements.getLNeDot().multiply(this.cNe)))).add((FieldElement)((CalculusFieldElement)elements.getPaDot().multiply(this.cPa))));
    }
}

