/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.ode.nonstiff;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.FieldElement;
import org.hipparchus.ode.FieldEquationsMapper;
import org.hipparchus.ode.FieldODEStateAndDerivative;
import org.hipparchus.ode.nonstiff.RungeKuttaFieldStateInterpolator;

class GillFieldStateInterpolator<T extends CalculusFieldElement<T>>
extends RungeKuttaFieldStateInterpolator<T> {
    private final T one_minus_inv_sqrt_2;
    private final T one_plus_inv_sqrt_2;

    GillFieldStateInterpolator(Field<T> field, boolean forward, T[][] yDotK, FieldODEStateAndDerivative<T> globalPreviousState, FieldODEStateAndDerivative<T> globalCurrentState, FieldODEStateAndDerivative<T> softPreviousState, FieldODEStateAndDerivative<T> softCurrentState, FieldEquationsMapper<T> mapper) {
        super(field, forward, yDotK, globalPreviousState, globalCurrentState, softPreviousState, softCurrentState, mapper);
        CalculusFieldElement sqrt = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)field.getZero()).add(0.5)).sqrt();
        this.one_minus_inv_sqrt_2 = (CalculusFieldElement)((CalculusFieldElement)field.getOne()).subtract((FieldElement)sqrt);
        this.one_plus_inv_sqrt_2 = (CalculusFieldElement)((CalculusFieldElement)field.getOne()).add((FieldElement)sqrt);
    }

    @Override
    protected GillFieldStateInterpolator<T> create(Field<T> newField, boolean newForward, T[][] newYDotK, FieldODEStateAndDerivative<T> newGlobalPreviousState, FieldODEStateAndDerivative<T> newGlobalCurrentState, FieldODEStateAndDerivative<T> newSoftPreviousState, FieldODEStateAndDerivative<T> newSoftCurrentState, FieldEquationsMapper<T> newMapper) {
        return new GillFieldStateInterpolator(newField, newForward, newYDotK, newGlobalPreviousState, newGlobalCurrentState, newSoftPreviousState, newSoftCurrentState, newMapper);
    }

    @Override
    protected FieldODEStateAndDerivative<T> computeInterpolatedStateAndDerivatives(FieldEquationsMapper<T> mapper, T time, T theta, T thetaH, T oneMinusThetaH) {
        CalculusFieldElement[] interpolatedDerivatives;
        CalculusFieldElement[] interpolatedState;
        CalculusFieldElement one = (CalculusFieldElement)time.getField().getOne();
        CalculusFieldElement twoTheta = (CalculusFieldElement)theta.multiply(2);
        CalculusFieldElement fourTheta2 = (CalculusFieldElement)twoTheta.multiply((FieldElement)twoTheta);
        CalculusFieldElement coeffDot1 = (CalculusFieldElement)((CalculusFieldElement)theta.multiply(twoTheta.subtract(3.0))).add(1.0);
        CalculusFieldElement cDot23 = (CalculusFieldElement)twoTheta.multiply(one.subtract(theta));
        CalculusFieldElement coeffDot2 = (CalculusFieldElement)cDot23.multiply(this.one_minus_inv_sqrt_2);
        CalculusFieldElement coeffDot3 = (CalculusFieldElement)cDot23.multiply(this.one_plus_inv_sqrt_2);
        CalculusFieldElement coeffDot4 = (CalculusFieldElement)theta.multiply(twoTheta.subtract(1.0));
        if (this.getGlobalPreviousState() != null && theta.getReal() <= 0.5) {
            CalculusFieldElement s = (CalculusFieldElement)thetaH.divide(6.0);
            CalculusFieldElement c23 = (CalculusFieldElement)s.multiply(((CalculusFieldElement)theta.multiply(6)).subtract((FieldElement)fourTheta2));
            CalculusFieldElement coeff1 = (CalculusFieldElement)s.multiply(((CalculusFieldElement)fourTheta2.subtract(theta.multiply(9))).add(6.0));
            CalculusFieldElement coeff2 = (CalculusFieldElement)c23.multiply(this.one_minus_inv_sqrt_2);
            CalculusFieldElement coeff3 = (CalculusFieldElement)c23.multiply(this.one_plus_inv_sqrt_2);
            CalculusFieldElement coeff4 = (CalculusFieldElement)s.multiply(fourTheta2.subtract(theta.multiply(3)));
            interpolatedState = this.previousStateLinearCombination(new CalculusFieldElement[]{coeff1, coeff2, coeff3, coeff4});
            interpolatedDerivatives = this.derivativeLinearCombination(new CalculusFieldElement[]{coeffDot1, coeffDot2, coeffDot3, coeffDot4});
        } else {
            CalculusFieldElement s = (CalculusFieldElement)oneMinusThetaH.divide(-6.0);
            CalculusFieldElement c23 = (CalculusFieldElement)s.multiply(((CalculusFieldElement)twoTheta.add(2.0)).subtract((FieldElement)fourTheta2));
            CalculusFieldElement coeff1 = (CalculusFieldElement)s.multiply(((CalculusFieldElement)fourTheta2.subtract(theta.multiply(5))).add(1.0));
            CalculusFieldElement coeff2 = (CalculusFieldElement)c23.multiply(this.one_minus_inv_sqrt_2);
            CalculusFieldElement coeff3 = (CalculusFieldElement)c23.multiply(this.one_plus_inv_sqrt_2);
            CalculusFieldElement coeff4 = (CalculusFieldElement)s.multiply(((CalculusFieldElement)fourTheta2.add(theta)).add(1.0));
            interpolatedState = this.currentStateLinearCombination(new CalculusFieldElement[]{coeff1, coeff2, coeff3, coeff4});
            interpolatedDerivatives = this.derivativeLinearCombination(new CalculusFieldElement[]{coeffDot1, coeffDot2, coeffDot3, coeffDot4});
        }
        return mapper.mapStateAndDerivative((CalculusFieldElement)time, interpolatedState, interpolatedDerivatives);
    }
}

