/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.exception.Localizable;
import org.orekit.attitudes.AttitudeProvider;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.frames.Frame;
import org.orekit.propagation.FieldAdditionalStateProvider;
import org.orekit.propagation.FieldPropagator;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.sampling.FieldStepHandlerMultiplexer;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.utils.TimeSpanMap;
import org.orekit.utils.TimeStampedFieldPVCoordinates;

public abstract class FieldAbstractPropagator<T extends CalculusFieldElement<T>>
implements FieldPropagator<T> {
    private FieldStepHandlerMultiplexer<T> multiplexer;
    private FieldAbsoluteDate<T> startDate;
    private AttitudeProvider attitudeProvider;
    private final List<FieldAdditionalStateProvider<T>> additionalStateProviders;
    private final Map<String, TimeSpanMap<T[]>> unmanagedStates;
    private final Field<T> field;
    private FieldSpacecraftState<T> initialState;

    protected FieldAbstractPropagator(Field<T> field) {
        this.field = field;
        this.multiplexer = new FieldStepHandlerMultiplexer();
        this.additionalStateProviders = new ArrayList<FieldAdditionalStateProvider<T>>();
        this.unmanagedStates = new HashMap<String, TimeSpanMap<T[]>>();
    }

    protected void setStartDate(FieldAbsoluteDate<T> startDate) {
        this.startDate = startDate;
    }

    protected FieldAbsoluteDate<T> getStartDate() {
        return this.startDate;
    }

    @Override
    public AttitudeProvider getAttitudeProvider() {
        return this.attitudeProvider;
    }

    @Override
    public void setAttitudeProvider(AttitudeProvider attitudeProvider) {
        this.attitudeProvider = attitudeProvider;
    }

    public Field<T> getField() {
        return this.field;
    }

    @Override
    public FieldSpacecraftState<T> getInitialState() {
        return this.initialState;
    }

    @Override
    public Frame getFrame() {
        return this.initialState.getFrame();
    }

    @Override
    public void resetInitialState(FieldSpacecraftState<T> state) {
        this.initialState = state;
        this.setStartDate(state.getDate());
    }

    @Override
    public FieldStepHandlerMultiplexer<T> getMultiplexer() {
        return this.multiplexer;
    }

    @Override
    public void addAdditionalStateProvider(FieldAdditionalStateProvider<T> additionalStateProvider) {
        if (this.isAdditionalStateManaged(additionalStateProvider.getName())) {
            throw new OrekitException((Localizable)OrekitMessages.ADDITIONAL_STATE_NAME_ALREADY_IN_USE, additionalStateProvider.getName());
        }
        this.additionalStateProviders.add(additionalStateProvider);
    }

    @Override
    public List<FieldAdditionalStateProvider<T>> getAdditionalStateProviders() {
        return Collections.unmodifiableList(this.additionalStateProviders);
    }

    protected FieldSpacecraftState<T> updateAdditionalStates(FieldSpacecraftState<T> original) {
        FieldSpacecraftState updated = original;
        for (Map.Entry<String, TimeSpanMap<T[]>> entry : this.unmanagedStates.entrySet()) {
            updated = updated.addAdditionalState(entry.getKey(), (CalculusFieldElement[])entry.getValue().get(original.getDate().toAbsoluteDate()));
        }
        for (FieldAdditionalStateProvider fieldAdditionalStateProvider : this.additionalStateProviders) {
            updated = updated.addAdditionalState(fieldAdditionalStateProvider.getName(), fieldAdditionalStateProvider.getAdditionalState(updated));
        }
        return updated;
    }

    @Override
    public boolean isAdditionalStateManaged(String name) {
        for (FieldAdditionalStateProvider<T> provider : this.additionalStateProviders) {
            if (!provider.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String[] getManagedAdditionalStates() {
        String[] managed = new String[this.additionalStateProviders.size()];
        for (int i = 0; i < managed.length; ++i) {
            managed[i] = this.additionalStateProviders.get(i).getName();
        }
        return managed;
    }

    @Override
    public FieldSpacecraftState<T> propagate(FieldAbsoluteDate<T> target) {
        if (this.startDate == null) {
            this.startDate = this.getInitialState().getDate();
        }
        return this.propagate(this.startDate, target);
    }

    @Override
    public TimeStampedFieldPVCoordinates<T> getPVCoordinates(FieldAbsoluteDate<T> date, Frame frame) {
        return this.propagate(date).getPVCoordinates(frame);
    }

    protected void initializePropagation() {
        this.unmanagedStates.clear();
        if (this.initialState != null) {
            for (Map.Entry<String, T[]> initial : this.initialState.getAdditionalStates().entrySet()) {
                if (this.isAdditionalStateManaged(initial.getKey())) continue;
                this.unmanagedStates.put(initial.getKey(), new TimeSpanMap<CalculusFieldElement[]>((CalculusFieldElement[])initial.getValue()));
            }
        }
    }

    protected void stateChanged(FieldSpacecraftState<T> state) {
        AbsoluteDate date = state.getDate().toAbsoluteDate();
        boolean forward = date.durationFrom(this.getStartDate().toAbsoluteDate()) >= 0.0;
        for (Map.Entry<String, T[]> changed : state.getAdditionalStates().entrySet()) {
            TimeSpanMap<T[]> tsm = this.unmanagedStates.get(changed.getKey());
            if (tsm == null) continue;
            if (forward) {
                tsm.addValidAfter((CalculusFieldElement[])changed.getValue(), date);
                continue;
            }
            tsm.addValidBefore((CalculusFieldElement[])changed.getValue(), date);
        }
    }
}

