/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.forces.maneuvers.propulsion;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.exception.Localizable;
import org.hipparchus.geometry.euclidean.threed.Rotation;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.orekit.attitudes.Attitude;
import org.orekit.attitudes.AttitudeProvider;
import org.orekit.attitudes.FieldAttitude;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.forces.maneuvers.propulsion.ThrustDirectionProvider;
import org.orekit.frames.Frame;
import org.orekit.frames.LOFType;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.utils.FieldPVCoordinatesProvider;
import org.orekit.utils.PVCoordinatesProvider;

public class ThrustDirectionAndAttitudeProvider
implements AttitudeProvider {
    private static final String FIELD_NAME_VARIABLE_DIRECTION = "variableDirectionInFrame";
    private static final String FIELD_NAME_DIRECTION_FRAME = "thrustDirectionFrame";
    private static final String FIELD_NAME_LOF_TYPE = "thrustDirectionLofType";
    private final ThrustDirectionAndAttitudeProviderType type;
    private final AttitudeProvider attitudeProvider;
    private final ThrustDirectionProvider variableDirectionInFrame;
    private final Vector3D thrusterAxisInSatelliteFrame;
    private final Frame thrustDirectionFrame;
    private final LOFType thrustDirectionLofType;

    private ThrustDirectionAndAttitudeProvider(ThrustDirectionAndAttitudeProviderType type, AttitudeProvider attitudeProvider, ThrustDirectionProvider variableDirectionInFrame, Vector3D thrusterAxisInSatelliteFrame, Frame frame, LOFType thrustDirectionLofType) {
        this.type = type;
        this.attitudeProvider = attitudeProvider;
        this.variableDirectionInFrame = variableDirectionInFrame;
        this.thrustDirectionFrame = frame;
        this.thrustDirectionLofType = thrustDirectionLofType;
        this.thrusterAxisInSatelliteFrame = thrusterAxisInSatelliteFrame;
    }

    private static void checkParameterNotNull(Object parameter, String name, ThrustDirectionAndAttitudeProviderType type) {
        if (parameter == null) {
            throw new OrekitException((Localizable)OrekitMessages.PARAMETER_NOT_SET, name, "ThrustDirectionAndAttitudeProvider-" + type.toString());
        }
    }

    public static ThrustDirectionAndAttitudeProvider buildFromFixedDirectionInSatelliteFrame(Vector3D direction) {
        ThrustDirectionAndAttitudeProvider obj = new ThrustDirectionAndAttitudeProvider(ThrustDirectionAndAttitudeProviderType.SATELLITE_ATTITUDE, null, null, direction, null, null);
        ThrustDirectionAndAttitudeProvider.checkParameterNotNull(direction, "thrusterAxisInSatelliteFrame", obj.type);
        return obj;
    }

    public static ThrustDirectionAndAttitudeProvider buildFromCustomAttitude(AttitudeProvider attitudeProvider, Vector3D direction) {
        ThrustDirectionAndAttitudeProvider obj = new ThrustDirectionAndAttitudeProvider(ThrustDirectionAndAttitudeProviderType.CUSTOM_ATTITUDE, attitudeProvider, null, direction, null, null);
        ThrustDirectionAndAttitudeProvider.checkParameterNotNull(attitudeProvider, "attitudeProvider", obj.type);
        ThrustDirectionAndAttitudeProvider.checkParameterNotNull(direction, "direction", obj.type);
        return obj;
    }

    public static ThrustDirectionAndAttitudeProvider buildFromDirectionInFrame(Frame thrustDirectionFrame, ThrustDirectionProvider variableDirectionInFrame, Vector3D thrusterAxisInSatelliteFrame) {
        ThrustDirectionAndAttitudeProvider obj = new ThrustDirectionAndAttitudeProvider(ThrustDirectionAndAttitudeProviderType.DIRECTION_IN_FRAME, null, variableDirectionInFrame, thrusterAxisInSatelliteFrame, thrustDirectionFrame, null);
        ThrustDirectionAndAttitudeProvider.checkParameterNotNull(variableDirectionInFrame, FIELD_NAME_VARIABLE_DIRECTION, obj.type);
        ThrustDirectionAndAttitudeProvider.checkParameterNotNull(thrustDirectionFrame, FIELD_NAME_DIRECTION_FRAME, obj.type);
        return obj;
    }

    public static ThrustDirectionAndAttitudeProvider buildFromDirectionInLOF(LOFType thrustDirectionLofType, ThrustDirectionProvider variableDirectionInFrame, Vector3D thrusterAxisInSatelliteFrame) {
        ThrustDirectionAndAttitudeProvider obj = new ThrustDirectionAndAttitudeProvider(ThrustDirectionAndAttitudeProviderType.DIRECTION_IN_LOF, null, variableDirectionInFrame, thrusterAxisInSatelliteFrame, null, thrustDirectionLofType);
        ThrustDirectionAndAttitudeProvider.checkParameterNotNull(variableDirectionInFrame, FIELD_NAME_VARIABLE_DIRECTION, obj.type);
        ThrustDirectionAndAttitudeProvider.checkParameterNotNull((Object)thrustDirectionLofType, FIELD_NAME_LOF_TYPE, obj.type);
        return obj;
    }

    public Vector3D getThrusterAxisInSatelliteFrame() {
        return this.thrusterAxisInSatelliteFrame;
    }

    @Override
    public Attitude getAttitude(PVCoordinatesProvider pvProv, AbsoluteDate date, Frame frame) {
        switch (this.type) {
            case CUSTOM_ATTITUDE: {
                return this.attitudeProvider.getAttitude(pvProv, date, frame);
            }
            case DIRECTION_IN_FRAME: 
            case DIRECTION_IN_LOF: {
                return this.getAttitudeFromFrame(pvProv, date, frame);
            }
        }
        throw new OrekitException((Localizable)OrekitMessages.INVALID_TYPE_FOR_FUNCTION, "ThrustDirectionAndAttitudeProvider.getAttitude", "type", this.type.toString());
    }

    @Override
    public <T extends CalculusFieldElement<T>> FieldAttitude<T> getAttitude(FieldPVCoordinatesProvider<T> pvProv, FieldAbsoluteDate<T> date, Frame frame) {
        throw new OrekitException((Localizable)OrekitMessages.FUNCTION_NOT_IMPLEMENTED, "ThrustDirectionAndAttitudeProvider with CalculusFieldElement");
    }

    protected Attitude getAttitudeFromFrame(PVCoordinatesProvider pvProv, AbsoluteDate date, Frame frame) {
        Rotation inertial2ThrusterFrame = this.type.equals((Object)ThrustDirectionAndAttitudeProviderType.DIRECTION_IN_FRAME) ? frame.getTransformTo(this.thrustDirectionFrame, date).getRotation() : this.thrustDirectionLofType.rotationFromInertial(pvProv.getPVCoordinates(date, frame));
        Vector3D thrustDirection = this.variableDirectionInFrame.computeThrustDirection(pvProv, date, frame);
        Vector3D thrustDirectionInertial = inertial2ThrusterFrame.applyInverseTo(thrustDirection);
        Rotation attitude = new Rotation(this.getThrusterAxisInSatelliteFrame(), thrustDirectionInertial);
        Attitude att = new Attitude(date, frame, attitude.revert(), Vector3D.ZERO, Vector3D.ZERO);
        return att;
    }

    public AttitudeProvider getManeuverAttitudeProvider() {
        ThrustDirectionAndAttitudeProvider attitudeProviderToReturn = null;
        if (this.type != ThrustDirectionAndAttitudeProviderType.SATELLITE_ATTITUDE) {
            attitudeProviderToReturn = this;
        }
        return attitudeProviderToReturn;
    }

    private static enum ThrustDirectionAndAttitudeProviderType {
        SATELLITE_ATTITUDE,
        CUSTOM_ATTITUDE,
        DIRECTION_IN_LOF,
        DIRECTION_IN_FRAME;

    }
}

