/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.forces.gravity.potential;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.Precision;
import org.orekit.annotation.DefaultDataContext;
import org.orekit.data.DataContext;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.errors.OrekitParseException;
import org.orekit.forces.gravity.potential.PotentialCoefficientsReader;
import org.orekit.forces.gravity.potential.RawSphericalHarmonicsProvider;
import org.orekit.forces.gravity.potential.SecularTrendSphericalHarmonics;
import org.orekit.forces.gravity.potential.TideSystem;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.DateComponents;
import org.orekit.time.TimeScale;

public class GRGSFormatReader
extends PotentialCoefficientsReader {
    private static final Pattern[] LINES;
    private AbsoluteDate referenceDate = null;
    private final List<List<Double>> cDot = new ArrayList<List<Double>>();
    private final List<List<Double>> sDot = new ArrayList<List<Double>>();

    @DefaultDataContext
    public GRGSFormatReader(String supportedNames, boolean missingCoefficientsAllowed) {
        this(supportedNames, missingCoefficientsAllowed, DataContext.getDefault().getTimeScales().getTT());
    }

    public GRGSFormatReader(String supportedNames, boolean missingCoefficientsAllowed, TimeScale timeScale) {
        super(supportedNames, missingCoefficientsAllowed, timeScale);
    }

    @Override
    public void loadData(InputStream input, String name) throws IOException, ParseException, OrekitException {
        this.setReadComplete(false);
        this.referenceDate = null;
        this.cDot.clear();
        this.sDot.clear();
        int lineNumber = 0;
        double[][] c = null;
        double[][] s = null;
        try (BufferedReader r = new BufferedReader(new InputStreamReader(input, StandardCharsets.UTF_8));){
            String line = r.readLine();
            while (line != null) {
                Matcher matcher;
                if (!(matcher = LINES[FastMath.min((int)LINES.length, (int)(++lineNumber)) - 1].matcher(line)).matches()) {
                    throw new OrekitParseException(OrekitMessages.UNABLE_TO_PARSE_LINE_IN_FILE, lineNumber, name, line);
                }
                if (lineNumber == 3) {
                    this.setAe(GRGSFormatReader.parseDouble(matcher.group(1)));
                    this.setMu(GRGSFormatReader.parseDouble(matcher.group(3)));
                } else if (lineNumber == 4) {
                    this.referenceDate = this.toDate(new DateComponents(Integer.parseInt(matcher.group(1)), 1, 1));
                } else if (lineNumber == 5) {
                    int degree = FastMath.min((int)this.getMaxParseDegree(), (int)Integer.parseInt(matcher.group(1)));
                    int order = FastMath.min((int)this.getMaxParseOrder(), (int)degree);
                    c = GRGSFormatReader.buildTriangularArray(degree, order, this.missingCoefficientsAllowed() ? 0.0 : Double.NaN);
                    s = GRGSFormatReader.buildTriangularArray(degree, order, this.missingCoefficientsAllowed() ? 0.0 : Double.NaN);
                } else if (lineNumber > 6) {
                    int i = Integer.parseInt(matcher.group(1).trim());
                    int j = Integer.parseInt(matcher.group(2).trim());
                    if (i < c.length && j < c[i].length) {
                        if ("DOT".equals(matcher.group(3).trim())) {
                            this.extendListOfLists(this.cDot, i, j, 0.0);
                            this.extendListOfLists(this.sDot, i, j, 0.0);
                            this.parseCoefficient(matcher.group(4), this.cDot, i, j, "Cdot", name);
                            this.parseCoefficient(matcher.group(5), this.sDot, i, j, "Sdot", name);
                        } else {
                            this.parseCoefficient(matcher.group(4), c, i, j, "C", name);
                            this.parseCoefficient(matcher.group(5), s, i, j, "S", name);
                        }
                    }
                }
                line = r.readLine();
            }
        }
        if (this.missingCoefficientsAllowed() && c.length > 0 && ((void)c[0]).length > 0 && Precision.equals((double)c[0][0], (double)0.0, (int)0)) {
            c[0][0] = 1.0;
        }
        this.setRawCoefficients(true, c, s, name);
        this.setTideSystem(TideSystem.UNKNOWN);
        this.setReadComplete(true);
    }

    @Override
    public RawSphericalHarmonicsProvider getProvider(boolean wantNormalized, int degree, int order) {
        RawSphericalHarmonicsProvider provider = this.getConstantProvider(wantNormalized, degree, order);
        if (!this.cDot.isEmpty()) {
            double[][] cArray = this.toArray(this.cDot);
            double[][] sArray = this.toArray(this.sDot);
            GRGSFormatReader.rescale(3.168808781402895E-8, true, cArray, sArray, wantNormalized, cArray, sArray);
            provider = new SecularTrendSphericalHarmonics(provider, this.referenceDate, cArray, sArray);
        }
        return provider;
    }

    static {
        String real = "[-+]?\\d?\\.\\d+[eEdD][-+]\\d\\d";
        String sep = ")\\s*(";
        String[] header = new String[]{"^\\s*FIELD - .*$", "^\\s+AE\\s+1/F\\s+GM\\s+OMEGA\\s*$", "^\\s*([-+]?\\d?\\.\\d+[eEdD][-+]\\d\\d)\\s*([-+]?\\d?\\.\\d+[eEdD][-+]\\d\\d)\\s*([-+]?\\d?\\.\\d+[eEdD][-+]\\d\\d)\\s*([-+]?\\d?\\.\\d+[eEdD][-+]\\d\\d)\\s*$", "^\\s*REFERENCE\\s+DATE\\s+:\\s+(\\d+)\\.0+\\s*$", "^\\s*MAXIMAL\\s+DEGREE\\s+:\\s+(\\d+)\\s.*$", "^\\s*L\\s+M\\s+DOT\\s+CBAR\\s+SBAR\\s+SIGMA C\\s+SIGMA S(\\s+LIB)?\\s*$"};
        String data = "^([ 0-9]{3})([ 0-9]{3})(   |DOT)\\s*([-+]?\\d?\\.\\d+[eEdD][-+]\\d\\d)\\s*([-+]?\\d?\\.\\d+[eEdD][-+]\\d\\d)\\s*([-+]?\\d?\\.\\d+[eEdD][-+]\\d\\d)\\s*([-+]?\\d?\\.\\d+[eEdD][-+]\\d\\d)(\\s+[0-9]+)?\\s*$";
        LINES = new Pattern[header.length + 1];
        for (int i = 0; i < header.length; ++i) {
            GRGSFormatReader.LINES[i] = Pattern.compile(header[i]);
        }
        GRGSFormatReader.LINES[GRGSFormatReader.LINES.length - 1] = Pattern.compile("^([ 0-9]{3})([ 0-9]{3})(   |DOT)\\s*([-+]?\\d?\\.\\d+[eEdD][-+]\\d\\d)\\s*([-+]?\\d?\\.\\d+[eEdD][-+]\\d\\d)\\s*([-+]?\\d?\\.\\d+[eEdD][-+]\\d\\d)\\s*([-+]?\\d?\\.\\d+[eEdD][-+]\\d\\d)(\\s+[0-9]+)?\\s*$");
    }
}

