/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.forces;

import java.util.ArrayList;
import java.util.List;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.FieldElement;
import org.hipparchus.geometry.Vector;
import org.hipparchus.geometry.euclidean.threed.FieldRotation;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Rotation;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.Precision;
import org.hipparchus.util.SinCos;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitInternalError;
import org.orekit.forces.drag.DragSensitive;
import org.orekit.forces.radiation.RadiationSensitive;
import org.orekit.frames.Frame;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.utils.PVCoordinatesProvider;
import org.orekit.utils.ParameterDriver;

public class BoxAndSolarArraySpacecraft
implements RadiationSensitive,
DragSensitive {
    private final double SCALE = FastMath.scalb((double)1.0, (int)-3);
    private final ParameterDriver dragParameterDriver;
    private final ParameterDriver liftParameterDriver;
    private final ParameterDriver absorptionParameterDriver;
    private final ParameterDriver reflectionParameterDriver;
    private final List<Facet> facets;
    private final double solarArrayArea;
    private final AbsoluteDate referenceDate;
    private final double rotationRate;
    private final Vector3D saX;
    private final Vector3D saY;
    private final Vector3D saZ;
    private final PVCoordinatesProvider sun;

    public BoxAndSolarArraySpacecraft(double xLength, double yLength, double zLength, PVCoordinatesProvider sun, double solarArrayArea, Vector3D solarArrayAxis, double dragCoeff, double absorptionCoeff, double reflectionCoeff) {
        this(BoxAndSolarArraySpacecraft.simpleBoxFacets(xLength, yLength, zLength), sun, solarArrayArea, solarArrayAxis, dragCoeff, 0.0, false, absorptionCoeff, reflectionCoeff);
    }

    public BoxAndSolarArraySpacecraft(double xLength, double yLength, double zLength, PVCoordinatesProvider sun, double solarArrayArea, Vector3D solarArrayAxis, double dragCoeff, double liftRatio, double absorptionCoeff, double reflectionCoeff) {
        this(BoxAndSolarArraySpacecraft.simpleBoxFacets(xLength, yLength, zLength), sun, solarArrayArea, solarArrayAxis, dragCoeff, liftRatio, absorptionCoeff, reflectionCoeff);
    }

    public BoxAndSolarArraySpacecraft(Facet[] facets, PVCoordinatesProvider sun, double solarArrayArea, Vector3D solarArrayAxis, double dragCoeff, double absorptionCoeff, double reflectionCoeff) {
        this(facets, sun, solarArrayArea, solarArrayAxis, dragCoeff, 0.0, false, absorptionCoeff, reflectionCoeff);
    }

    public BoxAndSolarArraySpacecraft(Facet[] facets, PVCoordinatesProvider sun, double solarArrayArea, Vector3D solarArrayAxis, double dragCoeff, double liftRatio, double absorptionCoeff, double reflectionCoeff) {
        this(facets, sun, solarArrayArea, solarArrayAxis, dragCoeff, liftRatio, true, absorptionCoeff, reflectionCoeff);
    }

    private BoxAndSolarArraySpacecraft(Facet[] facets, PVCoordinatesProvider sun, double solarArrayArea, Vector3D solarArrayAxis, double dragCoeff, double liftRatio, boolean useLift, double absorptionCoeff, double reflectionCoeff) {
        this.dragParameterDriver = this.buildDragParameterDriver(dragCoeff);
        this.liftParameterDriver = useLift ? this.buildLiftParameterDriver(liftRatio) : null;
        this.absorptionParameterDriver = this.buildAbsorptionParameterDriver(absorptionCoeff);
        this.reflectionParameterDriver = this.buildReflectionParameterDriver(reflectionCoeff);
        this.facets = BoxAndSolarArraySpacecraft.filter(facets);
        this.sun = sun;
        this.solarArrayArea = solarArrayArea;
        this.referenceDate = null;
        this.rotationRate = 0.0;
        this.saZ = solarArrayAxis.normalize();
        this.saY = null;
        this.saX = null;
    }

    public BoxAndSolarArraySpacecraft(double xLength, double yLength, double zLength, PVCoordinatesProvider sun, double solarArrayArea, Vector3D solarArrayAxis, AbsoluteDate referenceDate, Vector3D referenceNormal, double rotationRate, double dragCoeff, double absorptionCoeff, double reflectionCoeff) {
        this(BoxAndSolarArraySpacecraft.simpleBoxFacets(xLength, yLength, zLength), sun, solarArrayArea, solarArrayAxis, referenceDate, referenceNormal, rotationRate, dragCoeff, 0.0, false, absorptionCoeff, reflectionCoeff);
    }

    public BoxAndSolarArraySpacecraft(double xLength, double yLength, double zLength, PVCoordinatesProvider sun, double solarArrayArea, Vector3D solarArrayAxis, AbsoluteDate referenceDate, Vector3D referenceNormal, double rotationRate, double dragCoeff, double liftRatio, double absorptionCoeff, double reflectionCoeff) {
        this(BoxAndSolarArraySpacecraft.simpleBoxFacets(xLength, yLength, zLength), sun, solarArrayArea, solarArrayAxis, referenceDate, referenceNormal, rotationRate, dragCoeff, liftRatio, true, absorptionCoeff, reflectionCoeff);
    }

    public BoxAndSolarArraySpacecraft(Facet[] facets, PVCoordinatesProvider sun, double solarArrayArea, Vector3D solarArrayAxis, AbsoluteDate referenceDate, Vector3D referenceNormal, double rotationRate, double dragCoeff, double absorptionCoeff, double reflectionCoeff) {
        this(facets, sun, solarArrayArea, solarArrayAxis, referenceDate, referenceNormal, rotationRate, dragCoeff, 0.0, false, absorptionCoeff, reflectionCoeff);
    }

    public BoxAndSolarArraySpacecraft(Facet[] facets, PVCoordinatesProvider sun, double solarArrayArea, Vector3D solarArrayAxis, AbsoluteDate referenceDate, Vector3D referenceNormal, double rotationRate, double dragCoeff, double liftRatio, double absorptionCoeff, double reflectionCoeff) {
        this(facets, sun, solarArrayArea, solarArrayAxis, referenceDate, referenceNormal, rotationRate, dragCoeff, liftRatio, true, absorptionCoeff, reflectionCoeff);
    }

    private BoxAndSolarArraySpacecraft(Facet[] facets, PVCoordinatesProvider sun, double solarArrayArea, Vector3D solarArrayAxis, AbsoluteDate referenceDate, Vector3D referenceNormal, double rotationRate, double dragCoeff, double liftRatio, boolean useLift, double absorptionCoeff, double reflectionCoeff) {
        this.dragParameterDriver = this.buildDragParameterDriver(dragCoeff);
        this.liftParameterDriver = useLift ? this.buildLiftParameterDriver(liftRatio) : null;
        this.absorptionParameterDriver = this.buildAbsorptionParameterDriver(absorptionCoeff);
        this.reflectionParameterDriver = this.buildReflectionParameterDriver(reflectionCoeff);
        this.facets = BoxAndSolarArraySpacecraft.filter((Facet[])facets.clone());
        this.sun = sun;
        this.solarArrayArea = solarArrayArea;
        this.referenceDate = referenceDate;
        this.rotationRate = rotationRate;
        this.saZ = solarArrayAxis.normalize();
        this.saY = Vector3D.crossProduct((Vector3D)this.saZ, (Vector3D)referenceNormal).normalize();
        this.saX = Vector3D.crossProduct((Vector3D)this.saY, (Vector3D)this.saZ);
    }

    private ParameterDriver buildDragParameterDriver(double coeff) {
        try {
            return new ParameterDriver("drag coefficient", coeff, this.SCALE, 0.0, Double.POSITIVE_INFINITY);
        }
        catch (OrekitException oe) {
            throw new OrekitInternalError(oe);
        }
    }

    private ParameterDriver buildLiftParameterDriver(double coeff) {
        try {
            return new ParameterDriver("lift ratio", coeff, this.SCALE, 0.0, 1.0);
        }
        catch (OrekitException oe) {
            throw new OrekitInternalError(oe);
        }
    }

    private ParameterDriver buildAbsorptionParameterDriver(double coeff) {
        try {
            return new ParameterDriver("absorption coefficient", coeff, this.SCALE, 0.0, 1.0);
        }
        catch (OrekitException oe) {
            throw new OrekitInternalError(oe);
        }
    }

    private ParameterDriver buildReflectionParameterDriver(double coeff) {
        try {
            return new ParameterDriver("reflection coefficient", coeff, this.SCALE, 0.0, 1.0);
        }
        catch (OrekitException oe) {
            throw new OrekitInternalError(oe);
        }
    }

    @Override
    public List<ParameterDriver> getDragParametersDrivers() {
        ArrayList<ParameterDriver> drivers = new ArrayList<ParameterDriver>();
        drivers.add(this.dragParameterDriver);
        if (this.liftParameterDriver != null) {
            drivers.add(this.liftParameterDriver);
        }
        return drivers;
    }

    @Override
    public List<ParameterDriver> getRadiationParametersDrivers() {
        ArrayList<ParameterDriver> drivers = new ArrayList<ParameterDriver>();
        drivers.add(this.absorptionParameterDriver);
        drivers.add(this.reflectionParameterDriver);
        return drivers;
    }

    public synchronized Vector3D getNormal(AbsoluteDate date, Frame frame, Vector3D position, Rotation rotation) {
        if (this.referenceDate != null) {
            double alpha = this.rotationRate * date.durationFrom(this.referenceDate);
            SinCos scAlpha = FastMath.sinCos((double)alpha);
            return new Vector3D(scAlpha.cos(), this.saX, scAlpha.sin(), this.saY);
        }
        Vector3D sunInert = this.sun.getPVCoordinates(date, frame).getPosition().subtract((Vector)position).normalize();
        Vector3D sunSpacecraft = rotation.applyTo(sunInert);
        double d = Vector3D.dotProduct((Vector3D)sunSpacecraft, (Vector3D)this.saZ);
        double f = 1.0 - d * d;
        if (f < Precision.EPSILON) {
            return this.saZ.orthogonal();
        }
        double s = 1.0 / FastMath.sqrt((double)f);
        return new Vector3D(s, sunSpacecraft, -s * d, this.saZ);
    }

    public synchronized <T extends CalculusFieldElement<T>> FieldVector3D<T> getNormal(FieldAbsoluteDate<T> date, Frame frame, FieldVector3D<T> position, FieldRotation<T> rotation) {
        if (this.referenceDate != null) {
            CalculusFieldElement alpha = (CalculusFieldElement)date.durationFrom(this.referenceDate).multiply(this.rotationRate);
            return new FieldVector3D((CalculusFieldElement)alpha.cos(), this.saX, (CalculusFieldElement)alpha.sin(), this.saY);
        }
        FieldVector3D sunInert = position.subtract(this.sun.getPVCoordinates(date.toAbsoluteDate(), frame).getPosition()).negate().normalize();
        FieldVector3D sunSpacecraft = rotation.applyTo(sunInert);
        CalculusFieldElement d = FieldVector3D.dotProduct((FieldVector3D)sunSpacecraft, (Vector3D)this.saZ);
        CalculusFieldElement f = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)d.multiply((FieldElement)d)).subtract(1.0)).negate();
        if (f.getReal() < Precision.EPSILON) {
            return new FieldVector3D(f.getField(), this.saZ.orthogonal());
        }
        CalculusFieldElement s = (CalculusFieldElement)((CalculusFieldElement)f.sqrt()).reciprocal();
        return new FieldVector3D(s, sunSpacecraft, (CalculusFieldElement)((CalculusFieldElement)s.multiply((FieldElement)d)).negate(), new FieldVector3D(date.getField(), this.saZ));
    }

    @Override
    public Vector3D dragAcceleration(AbsoluteDate date, Frame frame, Vector3D position, Rotation rotation, double mass, double density, Vector3D relativeVelocity, double[] parameters) {
        double dragCoeff = parameters[0];
        double liftRatio = this.liftParameterDriver == null ? 0.0 : parameters[1];
        double vNorm2 = relativeVelocity.getNormSq();
        double vNorm = FastMath.sqrt((double)vNorm2);
        Vector3D vDir = rotation.applyTo(relativeVelocity.scalarMultiply(1.0 / vNorm));
        double coeff = density * dragCoeff * vNorm2 / (2.0 * mass);
        double oMr = 1.0 - liftRatio;
        Vector3D frontNormal = this.getNormal(date, frame, position, rotation);
        double s = coeff * this.solarArrayArea * Vector3D.dotProduct((Vector3D)frontNormal, (Vector3D)vDir);
        Vector3D acceleration = new Vector3D(oMr * FastMath.abs((double)s), vDir, liftRatio * s * 2.0, frontNormal);
        for (Facet facet : this.facets) {
            double dot = Vector3D.dotProduct((Vector3D)facet.getNormal(), (Vector3D)vDir);
            if (!(dot < 0.0)) continue;
            double f = coeff * facet.getArea() * dot;
            acceleration = new Vector3D(1.0, acceleration, oMr * FastMath.abs((double)f), vDir, liftRatio * f * 2.0, facet.getNormal());
        }
        return rotation.applyInverseTo(acceleration);
    }

    @Override
    public Vector3D radiationPressureAcceleration(AbsoluteDate date, Frame frame, Vector3D position, Rotation rotation, double mass, Vector3D flux, double[] parameters) {
        if (flux.getNormSq() < Precision.SAFE_MIN) {
            return Vector3D.ZERO;
        }
        Vector3D fluxSat = rotation.applyTo(flux);
        Vector3D normal = this.getNormal(date, frame, position, rotation);
        double dot = Vector3D.dotProduct((Vector3D)normal, (Vector3D)fluxSat);
        if (dot > 0.0) {
            dot = -dot;
            normal = normal.negate();
        }
        Vector3D force = this.facetRadiationAcceleration(normal, this.solarArrayArea, fluxSat, dot, parameters);
        for (Facet bodyFacet : this.facets) {
            normal = bodyFacet.getNormal();
            dot = Vector3D.dotProduct((Vector3D)normal, (Vector3D)fluxSat);
            if (!(dot < 0.0)) continue;
            force = force.add((Vector)this.facetRadiationAcceleration(normal, bodyFacet.getArea(), fluxSat, dot, parameters));
        }
        return rotation.applyInverseTo(new Vector3D(1.0 / mass, force));
    }

    @Override
    public <T extends CalculusFieldElement<T>> FieldVector3D<T> dragAcceleration(FieldAbsoluteDate<T> date, Frame frame, FieldVector3D<T> position, FieldRotation<T> rotation, T mass, T density, FieldVector3D<T> relativeVelocity, T[] parameters) {
        T dragCoeff = parameters[0];
        Object liftRatio = this.liftParameterDriver == null ? (CalculusFieldElement)dragCoeff.getField().getZero() : parameters[1];
        CalculusFieldElement vNorm2 = relativeVelocity.getNormSq();
        CalculusFieldElement vNorm = (CalculusFieldElement)vNorm2.sqrt();
        FieldVector3D vDir = rotation.applyTo(relativeVelocity.scalarMultiply((CalculusFieldElement)vNorm.reciprocal()));
        CalculusFieldElement coeff = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)density.multiply(0.5)).multiply(dragCoeff)).multiply((FieldElement)vNorm2)).divide(mass);
        CalculusFieldElement oMr = (CalculusFieldElement)((CalculusFieldElement)liftRatio.negate()).add(1.0);
        FieldVector3D<T> frontNormal = this.getNormal(date, frame, position, rotation);
        CalculusFieldElement s = (CalculusFieldElement)((CalculusFieldElement)coeff.multiply(this.solarArrayArea)).multiply((FieldElement)FieldVector3D.dotProduct(frontNormal, (FieldVector3D)vDir));
        FieldVector3D acceleration = new FieldVector3D((CalculusFieldElement)((CalculusFieldElement)s.abs()).multiply((FieldElement)oMr), vDir, (CalculusFieldElement)((CalculusFieldElement)s.multiply(liftRatio)).multiply(2), frontNormal);
        Field field = coeff.getField();
        for (Facet facet : this.facets) {
            CalculusFieldElement dot = FieldVector3D.dotProduct((Vector3D)facet.getNormal(), (FieldVector3D)vDir);
            if (!(dot.getReal() < 0.0)) continue;
            CalculusFieldElement f = (CalculusFieldElement)((CalculusFieldElement)coeff.multiply(facet.getArea())).multiply((FieldElement)dot);
            acceleration = new FieldVector3D((CalculusFieldElement)field.getOne(), acceleration, (CalculusFieldElement)((CalculusFieldElement)f.abs()).multiply((FieldElement)oMr), vDir, (CalculusFieldElement)((CalculusFieldElement)f.multiply(liftRatio)).multiply(2), new FieldVector3D(field, facet.getNormal()));
        }
        return rotation.applyInverseTo(acceleration);
    }

    @Override
    public <T extends CalculusFieldElement<T>> FieldVector3D<T> radiationPressureAcceleration(FieldAbsoluteDate<T> date, Frame frame, FieldVector3D<T> position, FieldRotation<T> rotation, T mass, FieldVector3D<T> flux, T[] parameters) {
        if (flux.getNormSq().getReal() < Precision.SAFE_MIN) {
            return FieldVector3D.getZero(date.getField());
        }
        FieldVector3D fluxSat = rotation.applyTo(flux);
        FieldVector3D normal = this.getNormal(date, frame, position, rotation);
        CalculusFieldElement dot = FieldVector3D.dotProduct(normal, (FieldVector3D)fluxSat);
        if (dot.getReal() > 0.0) {
            dot = (CalculusFieldElement)dot.negate();
            normal = normal.negate();
        }
        FieldVector3D force = this.facetRadiationAcceleration(normal, this.solarArrayArea, fluxSat, dot, (CalculusFieldElement[])parameters);
        for (Facet bodyFacet : this.facets) {
            normal = new FieldVector3D(date.getField(), bodyFacet.getNormal());
            dot = FieldVector3D.dotProduct((FieldVector3D)fluxSat, (FieldVector3D)normal);
            if (!(dot.getReal() < 0.0)) continue;
            force = force.add(this.facetRadiationAcceleration(normal, bodyFacet.getArea(), fluxSat, dot, (CalculusFieldElement[])parameters));
        }
        return rotation.applyInverseTo(new FieldVector3D((CalculusFieldElement)mass.reciprocal(), force));
    }

    private Vector3D facetRadiationAcceleration(Vector3D normal, double area, Vector3D fluxSat, double dot, double[] parameters) {
        double absorptionCoeff = parameters[0];
        double specularReflectionCoeff = parameters[1];
        double diffuseReflectionCoeff = 1.0 - (absorptionCoeff + specularReflectionCoeff);
        double psr = fluxSat.getNorm();
        double cN = 2.0 * area * dot * (diffuseReflectionCoeff / 3.0 - specularReflectionCoeff * dot / psr);
        double cS = area * dot / psr * (specularReflectionCoeff - 1.0);
        return new Vector3D(cN, normal, cS, fluxSat);
    }

    private <T extends CalculusFieldElement<T>> FieldVector3D<T> facetRadiationAcceleration(FieldVector3D<T> normal, double area, FieldVector3D<T> fluxSat, T dot, T[] parameters) {
        T absorptionCoeff = parameters[0];
        T specularReflectionCoeff = parameters[1];
        CalculusFieldElement diffuseReflectionCoeff = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)absorptionCoeff.add(specularReflectionCoeff)).negate()).add(1.0);
        CalculusFieldElement psr = fluxSat.getNorm();
        CalculusFieldElement cN = (CalculusFieldElement)((CalculusFieldElement)dot.multiply(-2.0 * area)).multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)dot.multiply(specularReflectionCoeff)).divide((FieldElement)psr)).subtract((FieldElement)((CalculusFieldElement)diffuseReflectionCoeff.divide(3.0)))));
        CalculusFieldElement cS = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)dot.multiply(area)).multiply((FieldElement)((CalculusFieldElement)specularReflectionCoeff.subtract(1.0)))).divide((FieldElement)psr);
        return new FieldVector3D(cN, normal, cS, fluxSat);
    }

    private static Facet[] simpleBoxFacets(double xLength, double yLength, double zLength) {
        return new Facet[]{new Facet(Vector3D.MINUS_I, yLength * zLength), new Facet(Vector3D.PLUS_I, yLength * zLength), new Facet(Vector3D.MINUS_J, xLength * zLength), new Facet(Vector3D.PLUS_J, xLength * zLength), new Facet(Vector3D.MINUS_K, xLength * yLength), new Facet(Vector3D.PLUS_K, xLength * yLength)};
    }

    private static List<Facet> filter(Facet[] facets) {
        ArrayList<Facet> filtered = new ArrayList<Facet>(facets.length);
        for (Facet facet : facets) {
            if (!(facet.getArea() > 0.0)) continue;
            filtered.add(facet);
        }
        return filtered;
    }

    public static class Facet {
        private final Vector3D normal;
        private final double area;

        public Facet(Vector3D normal, double area) {
            this.normal = normal.normalize();
            this.area = area;
        }

        public Vector3D getNormal() {
            return this.normal;
        }

        public double getArea() {
            return this.area;
        }
    }
}

