/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.semianalytical.dsst.utilities.hansen;

import java.lang.reflect.Array;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.FieldElement;
import org.hipparchus.analysis.differentiation.FieldGradient;
import org.hipparchus.analysis.polynomials.PolynomialFunction;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.MathArrays;
import org.orekit.propagation.semianalytical.dsst.utilities.NewcombOperators;
import org.orekit.propagation.semianalytical.dsst.utilities.hansen.HansenUtilities;
import org.orekit.propagation.semianalytical.dsst.utilities.hansen.PolynomialFunctionMatrix;

public class FieldHansenTesseralLinear<T extends CalculusFieldElement<T>> {
    private static final int SLICE = 10;
    private PolynomialFunction[][] mpvec;
    private PolynomialFunction[][] mpvecDeriv;
    private T[][] hansenRoot;
    private T[][] hansenDerivRoot;
    private int Nmin;
    private int N0;
    private int s;
    private int j;
    private int numSlices;
    private int offset;
    private FieldHansenCoefficientsBySeries<T>[] hansenInit;

    public FieldHansenTesseralLinear(int nMax, int s, int j, int n0, int maxHansen, Field<T> field) {
        this.offset = nMax + 1;
        this.Nmin = -nMax - 1;
        this.N0 = -n0 - 4;
        this.s = s;
        this.j = j;
        int maxRoots = FastMath.min((int)4, (int)(this.N0 - this.Nmin + 4));
        this.hansenInit = (FieldHansenCoefficientsBySeries[])Array.newInstance(FieldHansenCoefficientsBySeries.class, maxRoots);
        for (int i = 0; i < maxRoots; ++i) {
            this.hansenInit[i] = new FieldHansenCoefficientsBySeries<T>(this.N0 - i + 3, s, j, maxHansen, field);
        }
        int size = this.N0 - this.Nmin;
        this.numSlices = (int)FastMath.max((double)FastMath.ceil((double)((double)size / 10.0)), (double)1.0);
        this.hansenRoot = (CalculusFieldElement[][])MathArrays.buildArray(field, (int)this.numSlices, (int)4);
        this.hansenDerivRoot = (CalculusFieldElement[][])MathArrays.buildArray(field, (int)this.numSlices, (int)4);
        if (size > 0) {
            this.mpvec = new PolynomialFunction[size][];
            this.mpvecDeriv = new PolynomialFunction[size][];
            this.generatePolynomials();
        }
    }

    private PolynomialFunction a(int mnm1) {
        double r1 = ((double)mnm1 + 2.0) * (2.0 * (double)mnm1 + 5.0);
        double r2 = (2.0 + (double)mnm1 + (double)this.s) * (2.0 + (double)mnm1 - (double)this.s);
        return new PolynomialFunction(new double[]{0.0, 0.0, r1 / r2});
    }

    private PolynomialFunction b(int mnm1) {
        double r2 = (2.0 + (double)mnm1 + (double)this.s) * (2.0 + (double)mnm1 - (double)this.s);
        double d1 = ((double)mnm1 + 3.0) * 2.0 * (double)this.j * (double)this.s / (r2 * ((double)mnm1 + 4.0));
        double d2 = ((double)mnm1 + 3.0) * ((double)mnm1 + 2.0) / r2;
        return new PolynomialFunction(new double[]{0.0, -d1, -d2});
    }

    private PolynomialFunction c(int mnm1) {
        double r1 = (double)(this.j * this.j) * ((double)mnm1 + 2.0);
        double r2 = ((double)mnm1 + 4.0) * (2.0 + (double)mnm1 + (double)this.s) * (2.0 + (double)mnm1 - (double)this.s);
        return new PolynomialFunction(new double[]{0.0, 0.0, r1 / r2});
    }

    private PolynomialFunction d(int mnm1) {
        return new PolynomialFunction(new double[]{0.0, 0.0, 1.0});
    }

    private PolynomialFunction f(int n) {
        double r1 = ((double)n + 3.0) * (double)this.j * (double)this.s;
        double r2 = ((double)n + 4.0) * (2.0 + (double)n + (double)this.s) * (2.0 + (double)n - (double)this.s);
        return new PolynomialFunction(new double[]{0.0, 0.0, 0.0, r1 / r2});
    }

    private void generatePolynomials() {
        PolynomialFunctionMatrix A = HansenUtilities.buildIdentityMatrix4();
        PolynomialFunctionMatrix B = HansenUtilities.buildZeroMatrix4();
        PolynomialFunctionMatrix D = HansenUtilities.buildZeroMatrix4();
        PolynomialFunctionMatrix a = HansenUtilities.buildZeroMatrix4();
        a.setMatrixLine(0, new PolynomialFunction[]{HansenUtilities.ZERO, HansenUtilities.ONE, HansenUtilities.ZERO, HansenUtilities.ZERO});
        a.setMatrixLine(1, new PolynomialFunction[]{HansenUtilities.ZERO, HansenUtilities.ZERO, HansenUtilities.ONE, HansenUtilities.ZERO});
        a.setMatrixLine(2, new PolynomialFunction[]{HansenUtilities.ZERO, HansenUtilities.ZERO, HansenUtilities.ZERO, HansenUtilities.ONE});
        int sliceCounter = 0;
        for (int i = this.N0 - 1; i > this.Nmin - 1; --i) {
            int index = i + this.offset;
            a.setMatrixLine(3, new PolynomialFunction[]{this.c(i), HansenUtilities.ZERO, this.b(i), this.a(i)});
            A = A.multiply(a);
            this.mpvec[index] = A.getMatrixLine(3);
            D = D.multiply(a);
            B.setMatrixLine(3, new PolynomialFunction[]{HansenUtilities.ZERO, this.f(i), HansenUtilities.ZERO, this.d(i)});
            D = D.add(A.multiply(B));
            this.mpvecDeriv[index] = D.getMatrixLine(3);
            if (++sliceCounter % 10 != 0) continue;
            A = HansenUtilities.buildIdentityMatrix4();
            D = HansenUtilities.buildZeroMatrix4();
        }
    }

    public void computeInitValues(T e2, T chi, T chi2) {
        int i;
        int maxRoots = FastMath.min((int)4, (int)(this.N0 - this.Nmin + 4));
        for (i = 0; i < maxRoots; ++i) {
            FieldGradient hansenKernel = ((FieldHansenCoefficientsBySeries)this.hansenInit[i]).getValueGradient(e2, chi, chi2);
            this.hansenRoot[0][i] = hansenKernel.getValue();
            this.hansenDerivRoot[0][i] = hansenKernel.getPartialDerivative(0);
        }
        for (i = 1; i < this.numSlices; ++i) {
            for (int k = 0; k < 4; ++k) {
                PolynomialFunction[] mv = this.mpvec[this.N0 - i * 10 - k + 3 + this.offset];
                PolynomialFunction[] sv = this.mpvecDeriv[this.N0 - i * 10 - k + 3 + this.offset];
                this.hansenDerivRoot[i][k] = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)mv[3].value(chi).multiply(this.hansenDerivRoot[i - 1][3])).add((FieldElement)((CalculusFieldElement)mv[2].value(chi).multiply(this.hansenDerivRoot[i - 1][2])))).add((FieldElement)((CalculusFieldElement)mv[1].value(chi).multiply(this.hansenDerivRoot[i - 1][1])))).add((FieldElement)((CalculusFieldElement)mv[0].value(chi).multiply(this.hansenDerivRoot[i - 1][0])))).add((FieldElement)((CalculusFieldElement)sv[3].value(chi).multiply(this.hansenRoot[i - 1][3])))).add((FieldElement)((CalculusFieldElement)sv[2].value(chi).multiply(this.hansenRoot[i - 1][2])))).add((FieldElement)((CalculusFieldElement)sv[1].value(chi).multiply(this.hansenRoot[i - 1][1])))).add((FieldElement)((CalculusFieldElement)sv[0].value(chi).multiply(this.hansenRoot[i - 1][0])));
                this.hansenRoot[i][k] = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)mv[3].value(chi).multiply(this.hansenRoot[i - 1][3])).add((FieldElement)((CalculusFieldElement)mv[2].value(chi).multiply(this.hansenRoot[i - 1][2])))).add((FieldElement)((CalculusFieldElement)mv[1].value(chi).multiply(this.hansenRoot[i - 1][1])))).add((FieldElement)((CalculusFieldElement)mv[0].value(chi).multiply(this.hansenRoot[i - 1][0])));
            }
        }
    }

    public T getValue(int mnm1, T chi) {
        int n = -mnm1 - 1;
        int sliceNo = (n + this.N0 + 4) / 10;
        if (sliceNo < this.numSlices) {
            int indexInSlice = (n + this.N0 + 4) % 10;
            if (indexInSlice <= 3) {
                return this.hansenRoot[sliceNo][indexInSlice];
            }
        } else {
            --sliceNo;
        }
        PolynomialFunction[] v = this.mpvec[mnm1 + this.offset];
        return (T)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)v[3].value(chi).multiply(this.hansenRoot[sliceNo][3])).add((FieldElement)((CalculusFieldElement)v[2].value(chi).multiply(this.hansenRoot[sliceNo][2])))).add((FieldElement)((CalculusFieldElement)v[1].value(chi).multiply(this.hansenRoot[sliceNo][1])))).add((FieldElement)((CalculusFieldElement)v[0].value(chi).multiply(this.hansenRoot[sliceNo][0]))));
    }

    public T getDerivative(int mnm1, T chi) {
        int n = -mnm1 - 1;
        int sliceNo = (n + this.N0 + 4) / 10;
        if (sliceNo < this.numSlices) {
            int indexInSlice = (n + this.N0 + 4) % 10;
            if (indexInSlice <= 3) {
                return this.hansenDerivRoot[sliceNo][indexInSlice];
            }
        } else {
            --sliceNo;
        }
        PolynomialFunction[] v = this.mpvec[mnm1 + this.offset];
        PolynomialFunction[] vv = this.mpvecDeriv[mnm1 + this.offset];
        return (T)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)v[3].value(chi).multiply(this.hansenDerivRoot[sliceNo][3])).add((FieldElement)((CalculusFieldElement)v[2].value(chi).multiply(this.hansenDerivRoot[sliceNo][2])))).add((FieldElement)((CalculusFieldElement)v[1].value(chi).multiply(this.hansenDerivRoot[sliceNo][1])))).add((FieldElement)((CalculusFieldElement)v[0].value(chi).multiply(this.hansenDerivRoot[sliceNo][0])))).add((FieldElement)((CalculusFieldElement)vv[3].value(chi).multiply(this.hansenRoot[sliceNo][3])))).add((FieldElement)((CalculusFieldElement)vv[2].value(chi).multiply(this.hansenRoot[sliceNo][2])))).add((FieldElement)((CalculusFieldElement)vv[1].value(chi).multiply(this.hansenRoot[sliceNo][1])))).add((FieldElement)((CalculusFieldElement)vv[0].value(chi).multiply(this.hansenRoot[sliceNo][0]))));
    }

    private static class FieldHansenCoefficientsBySeries<T extends CalculusFieldElement<T>> {
        private final int mnm1;
        private final int s;
        private final int j;
        private final int maxNewcomb;
        private PolynomialFunction polynomial;

        FieldHansenCoefficientsBySeries(int mnm1, int s, int j, int maxHansen, Field<T> field) {
            this.mnm1 = mnm1;
            this.s = s;
            this.j = j;
            this.maxNewcomb = maxHansen;
            this.polynomial = this.generatePolynomial();
        }

        private FieldGradient<T> getValueGradient(T e2, T chi, T chi2) {
            CalculusFieldElement zero = (CalculusFieldElement)e2.getField().getZero();
            FieldGradient serie = (FieldGradient)this.polynomial.value((CalculusFieldElement)FieldGradient.variable((int)1, (int)0, e2));
            CalculusFieldElement value = (CalculusFieldElement)((CalculusFieldElement)FastMath.pow(chi2, (int)(-this.mnm1 - 1)).multiply((FieldElement)serie.getValue())).divide(chi);
            CalculusFieldElement coef = (CalculusFieldElement)zero.subtract((double)this.mnm1 + 1.5);
            CalculusFieldElement derivative = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)coef.multiply(chi2)).multiply((FieldElement)value)).add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)FastMath.pow(chi2, (int)(-this.mnm1 - 1)).multiply((FieldElement)serie.getPartialDerivative(0))).divide(chi)));
            return new FieldGradient(value, new CalculusFieldElement[]{derivative});
        }

        private PolynomialFunction generatePolynomial() {
            int aHT = FastMath.max((int)(this.j - this.s), (int)0);
            int bHT = FastMath.max((int)(this.s - this.j), (int)0);
            double[] coefficients = new double[this.maxNewcomb + 1];
            for (int alphaHT = 0; alphaHT <= this.maxNewcomb; ++alphaHT) {
                coefficients[alphaHT] = NewcombOperators.getValue(alphaHT + aHT, alphaHT + bHT, this.mnm1, this.s);
            }
            return new PolynomialFunction(coefficients);
        }
    }
}

