/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.geometry.fov;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.FieldElement;
import org.hipparchus.analysis.differentiation.DSFactory;
import org.hipparchus.analysis.differentiation.DerivativeStructure;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.SinCos;
import org.orekit.geometry.fov.SmoothFieldOfView;
import org.orekit.propagation.events.VisibilityTrigger;

public class EllipticalFieldOfView
extends SmoothFieldOfView {
    private static final DSFactory FACTORY = new DSFactory(1, 3);
    private final double halfApertureAlongX;
    private final double halfApertureAlongY;
    private final double tanX;
    private final double tanY;
    private final Vector3D u;
    private final Vector3D focus1;
    private final Vector3D focus2;
    private final Vector3D crossF1F2;
    private final double dotF1F2;
    private final double gamma;
    private final double d;
    private double a;

    public EllipticalFieldOfView(Vector3D center, Vector3D primaryMeridian, double halfApertureAlongX, double halfApertureAlongY, double margin) {
        super(center, primaryMeridian, margin);
        double b;
        Vector3D v;
        if (halfApertureAlongX >= halfApertureAlongY) {
            this.u = this.getX();
            v = this.getY();
            this.a = halfApertureAlongX;
            b = halfApertureAlongY;
        } else {
            this.u = this.getY();
            v = this.getX().negate();
            this.a = halfApertureAlongY;
            b = halfApertureAlongX;
        }
        double cos = FastMath.cos((double)this.a) / FastMath.cos((double)b);
        double sin = FastMath.sqrt((double)(1.0 - cos * cos));
        this.halfApertureAlongX = halfApertureAlongX;
        this.halfApertureAlongY = halfApertureAlongY;
        this.tanX = FastMath.tan((double)halfApertureAlongX);
        this.tanY = FastMath.tan((double)halfApertureAlongY);
        this.focus1 = new Vector3D(sin, this.u, cos, this.getZ());
        this.focus2 = new Vector3D(-sin, this.u, cos, this.getZ());
        this.crossF1F2 = new Vector3D(-2.0 * sin * cos, v);
        this.dotF1F2 = 2.0 * cos * cos - 1.0;
        this.gamma = FastMath.acos((double)cos);
        this.d = 1.0 / (1.0 - this.dotF1F2 * this.dotF1F2);
    }

    public double getHalfApertureAlongX() {
        return this.halfApertureAlongX;
    }

    public double getHalfApertureAlongY() {
        return this.halfApertureAlongY;
    }

    public Vector3D getFocus1() {
        return this.focus1;
    }

    public Vector3D getFocus2() {
        return this.focus2;
    }

    @Override
    public double offsetFromBoundary(Vector3D lineOfSight, double angularRadius, VisibilityTrigger trigger) {
        double margin = this.getMargin();
        double correctedRadius = trigger.radiusCorrection(angularRadius);
        double deadBand = margin + angularRadius;
        double crudeDistance = Vector3D.angle((Vector3D)this.getZ(), (Vector3D)lineOfSight) - this.a;
        if (crudeDistance > deadBand + 0.01) {
            return crudeDistance + correctedRadius - margin;
        }
        double d1 = Vector3D.angle((Vector3D)lineOfSight, (Vector3D)this.focus1);
        double d2 = Vector3D.angle((Vector3D)lineOfSight, (Vector3D)this.focus2);
        Vector3D closest = this.projectToBoundary(lineOfSight, d1, d2);
        double rawOffset = FastMath.copySign((double)Vector3D.angle((Vector3D)lineOfSight, (Vector3D)closest), (double)(d1 + d2 - 2.0 * this.a));
        return rawOffset + correctedRadius - this.getMargin();
    }

    @Override
    public Vector3D projectToBoundary(Vector3D lineOfSight) {
        double d1 = Vector3D.angle((Vector3D)lineOfSight, (Vector3D)this.focus1);
        double d2 = Vector3D.angle((Vector3D)lineOfSight, (Vector3D)this.focus2);
        return this.projectToBoundary(lineOfSight, d1, d2);
    }

    private Vector3D projectToBoundary(Vector3D lineOfSight, double d1, double d2) {
        FieldVector3D<DerivativeStructure> pn;
        DerivativeStructure yn;
        Vector3D los = lineOfSight.normalize();
        double side = Vector3D.dotProduct((Vector3D)los, (Vector3D)this.crossF1F2);
        if (FastMath.abs((double)side) < 1.0E-12) {
            return this.directionAt(Vector3D.dotProduct((Vector3D)los, (Vector3D)this.u) > 0.0 ? 0.0 : Math.PI);
        }
        double offset0 = 0.5 * (d1 - d2);
        double minOffset = -this.gamma;
        double maxOffset = this.gamma;
        DerivativeStructure offset = FACTORY.variable(0, offset0);
        for (int i = 0; i < 100 && !((yn = (DerivativeStructure)FieldVector3D.angle(pn = this.directionAt(offset.add(this.a), offset.subtract(this.a).negate(), side), (Vector3D)los)).getValue() < 1.0E-12); ++i) {
            double f0 = yn.getPartialDerivative(new int[]{1});
            double f1 = yn.getPartialDerivative(new int[]{2});
            int[] nArray = new int[]{3};
            double f2 = yn.getPartialDerivative(nArray);
            double dx = -2.0 * f0 * f1 / (2.0 * f1 * f1 - f0 * f2);
            if (dx * f0 > 0.0) {
                dx = -1.5 * f2 / f1;
            }
            if (dx < 0.0) {
                maxOffset = offset.getValue();
                if (offset.getValue() + dx <= minOffset) {
                    dx = 0.5 * (minOffset - offset.getValue());
                }
            } else {
                minOffset = offset.getValue();
                if (offset.getValue() + dx >= maxOffset) {
                    dx = 0.5 * (maxOffset - offset.getValue());
                }
            }
            offset = offset.add(dx);
            if (FastMath.abs((double)dx) < 1.0E-12) break;
        }
        return this.directionAt(this.a + offset.getReal(), this.a - offset.getReal(), side);
    }

    @Override
    protected Vector3D directionAt(double angle) {
        SinCos sce = FastMath.sinCos((double)angle);
        Vector3D dEll = new Vector3D(this.tanX * sce.cos(), this.tanY * sce.sin(), 1.0).normalize();
        return new Vector3D(dEll.getX(), this.getX(), dEll.getY(), this.getY(), dEll.getZ(), this.getZ());
    }

    private Vector3D directionAt(double d1, double d2, double sign) {
        double cos1 = FastMath.cos((double)d1);
        double cos2 = FastMath.cos((double)d2);
        double a1 = (cos1 - cos2 * this.dotF1F2) * this.d;
        double a2 = (cos2 - cos1 * this.dotF1F2) * this.d;
        double ac = FastMath.sqrt((double)((1.0 - (a1 * a1 + 2.0 * a1 * a2 * this.dotF1F2 + a2 * a2)) * this.d));
        return new Vector3D(a1, this.focus1, a2, this.focus2, FastMath.copySign((double)ac, (double)sign), this.crossF1F2);
    }

    private <T extends CalculusFieldElement<T>> FieldVector3D<T> directionAt(T d1, T d2, double sign) {
        CalculusFieldElement cos1 = FastMath.cos(d1);
        CalculusFieldElement cos2 = FastMath.cos(d2);
        CalculusFieldElement a1 = (CalculusFieldElement)((CalculusFieldElement)cos1.subtract((FieldElement)((CalculusFieldElement)cos2.multiply(this.dotF1F2)))).multiply(this.d);
        CalculusFieldElement a2 = (CalculusFieldElement)((CalculusFieldElement)cos2.subtract((FieldElement)((CalculusFieldElement)cos1.multiply(this.dotF1F2)))).multiply(this.d);
        CalculusFieldElement ac = FastMath.sqrt((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)a1.multiply((FieldElement)((CalculusFieldElement)a1.add((FieldElement)((CalculusFieldElement)a2.multiply(2.0 * this.dotF1F2)))))).add((FieldElement)((CalculusFieldElement)a2.multiply((FieldElement)a2)))).negate()).add(1.0)).multiply(this.d)));
        return new FieldVector3D(a1, this.focus1, a2, this.focus2, FastMath.copySign((CalculusFieldElement)ac, (double)sign), this.crossF1F2);
    }
}

