/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.forces.maneuvers;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.orekit.attitudes.AttitudeProvider;
import org.orekit.forces.maneuvers.Maneuver;
import org.orekit.forces.maneuvers.propulsion.AbstractConstantThrustPropulsionModel;
import org.orekit.forces.maneuvers.propulsion.BasicConstantThrustPropulsionModel;
import org.orekit.forces.maneuvers.trigger.DateBasedManeuverTriggers;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.SpacecraftState;
import org.orekit.time.AbsoluteDate;

public class ConstantThrustManeuver
extends Maneuver {
    public ConstantThrustManeuver(AbsoluteDate date, double duration, double thrust, double isp, Vector3D direction) {
        this(date, duration, thrust, isp, direction, "");
    }

    public ConstantThrustManeuver(AbsoluteDate date, double duration, double thrust, double isp, AttitudeProvider attitudeOverride, Vector3D direction) {
        this(date, duration, thrust, isp, attitudeOverride, direction, "");
    }

    public ConstantThrustManeuver(AbsoluteDate date, double duration, double thrust, double isp, Vector3D direction, String name) {
        this(date, duration, thrust, isp, null, direction, name);
    }

    public ConstantThrustManeuver(AbsoluteDate date, double duration, double thrust, double isp, AttitudeProvider attitudeOverride, Vector3D direction, String name) {
        this(date, duration, attitudeOverride, new BasicConstantThrustPropulsionModel(thrust, isp, direction, name));
    }

    public ConstantThrustManeuver(AbsoluteDate date, double duration, AttitudeProvider attitudeOverride, AbstractConstantThrustPropulsionModel constantThrustPropulsionModel) {
        this(attitudeOverride, new DateBasedManeuverTriggers(date, duration), constantThrustPropulsionModel);
    }

    public ConstantThrustManeuver(AttitudeProvider attitudeOverride, DateBasedManeuverTriggers dateBasedManeuverTriggers, AbstractConstantThrustPropulsionModel constantThrustPropulsionModel) {
        super(attitudeOverride, dateBasedManeuverTriggers, constantThrustPropulsionModel);
    }

    public Vector3D getThrustVector() {
        return ((AbstractConstantThrustPropulsionModel)this.getPropulsionModel()).getThrustVector();
    }

    public double getThrust() {
        return this.getThrustVector().getNorm();
    }

    public double getISP() {
        return ((AbstractConstantThrustPropulsionModel)this.getPropulsionModel()).getIsp();
    }

    public double getFlowRate() {
        return ((AbstractConstantThrustPropulsionModel)this.getPropulsionModel()).getFlowRate();
    }

    public Vector3D getDirection() {
        return this.getThrustVector().normalize();
    }

    public AbsoluteDate getStartDate() {
        return ((DateBasedManeuverTriggers)this.getManeuverTriggers()).getStartDate();
    }

    public AbsoluteDate getEndDate() {
        return ((DateBasedManeuverTriggers)this.getManeuverTriggers()).getEndDate();
    }

    public double getDuration() {
        return ((DateBasedManeuverTriggers)this.getManeuverTriggers()).getDuration();
    }

    public boolean isFiring(SpacecraftState s) {
        return this.isFiring(s.getDate());
    }

    public <T extends CalculusFieldElement<T>> boolean isFiring(FieldSpacecraftState<T> s) {
        return this.isFiring(s.getDate().toAbsoluteDate());
    }

    public boolean isFiring(AbsoluteDate date) {
        return this.getManeuverTriggers().isFiring(date, new double[0]);
    }
}

