/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.attitudes;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.geometry.euclidean.threed.Rotation;
import org.orekit.annotation.DefaultDataContext;
import org.orekit.attitudes.Attitude;
import org.orekit.attitudes.AttitudeProvider;
import org.orekit.attitudes.FieldAttitude;
import org.orekit.data.DataContext;
import org.orekit.frames.FieldTransform;
import org.orekit.frames.Frame;
import org.orekit.frames.Transform;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.utils.FieldPVCoordinatesProvider;
import org.orekit.utils.PVCoordinatesProvider;

public class InertialProvider
implements AttitudeProvider {
    private final Frame satelliteFrame;

    @DefaultDataContext
    public InertialProvider(Rotation rotation) {
        this(rotation, DataContext.getDefault().getFrames().getEME2000());
    }

    public InertialProvider(Frame frame) {
        this.satelliteFrame = frame;
    }

    public InertialProvider(Rotation rotation, Frame reference) {
        this.satelliteFrame = new Frame(reference, new Transform(AbsoluteDate.ARBITRARY_EPOCH, rotation), null, false);
    }

    public static AttitudeProvider of(Frame satelliteFrame) {
        return new InertialProvider(satelliteFrame);
    }

    @Override
    public Attitude getAttitude(PVCoordinatesProvider pvProv, AbsoluteDate date, Frame frame) {
        Transform t = frame.getTransformTo(this.satelliteFrame, date);
        return new Attitude(date, frame, t.getRotation(), t.getRotationRate(), t.getRotationAcceleration());
    }

    @Override
    public <T extends CalculusFieldElement<T>> FieldAttitude<T> getAttitude(FieldPVCoordinatesProvider<T> pvProv, FieldAbsoluteDate<T> date, Frame frame) {
        FieldTransform<T> t = frame.getTransformTo(this.satelliteFrame, date);
        return new FieldAttitude<T>(date, frame, t.getRotation(), t.getRotationRate(), t.getRotationAcceleration());
    }
}

