/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.analysis.interpolation;

import java.lang.reflect.Array;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.analysis.interpolation.FieldUnivariateInterpolator;
import org.hipparchus.analysis.interpolation.UnivariateInterpolator;
import org.hipparchus.analysis.polynomials.FieldPolynomialFunction;
import org.hipparchus.analysis.polynomials.FieldPolynomialSplineFunction;
import org.hipparchus.analysis.polynomials.PolynomialFunction;
import org.hipparchus.analysis.polynomials.PolynomialSplineFunction;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.util.MathArrays;
import org.hipparchus.util.MathUtils;

public class SplineInterpolator
implements UnivariateInterpolator,
FieldUnivariateInterpolator {
    @Override
    public PolynomialSplineFunction interpolate(double[] x, double[] y) throws MathIllegalArgumentException {
        MathUtils.checkNotNull(x);
        MathUtils.checkNotNull(y);
        MathArrays.checkEqualLength(x, y);
        if (x.length < 3) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.NUMBER_OF_POINTS, x.length, 3, true);
        }
        int n = x.length - 1;
        MathArrays.checkOrder(x);
        double[] h = new double[n];
        for (int i = 0; i < n; ++i) {
            h[i] = x[i + 1] - x[i];
        }
        double[] mu = new double[n];
        double[] z = new double[n + 1];
        mu[0] = 0.0;
        z[0] = 0.0;
        for (int i = 1; i < n; ++i) {
            double g = 2.0 * (x[i + 1] - x[i - 1]) - h[i - 1] * mu[i - 1];
            mu[i] = h[i] / g;
            z[i] = (3.0 * (y[i + 1] * h[i - 1] - y[i] * (x[i + 1] - x[i - 1]) + y[i - 1] * h[i]) / (h[i - 1] * h[i]) - h[i - 1] * z[i - 1]) / g;
        }
        double[] b = new double[n];
        double[] c = new double[n + 1];
        double[] d = new double[n];
        z[n] = 0.0;
        c[n] = 0.0;
        for (int j = n - 1; j >= 0; --j) {
            c[j] = z[j] - mu[j] * c[j + 1];
            b[j] = (y[j + 1] - y[j]) / h[j] - h[j] * (c[j + 1] + 2.0 * c[j]) / 3.0;
            d[j] = (c[j + 1] - c[j]) / (3.0 * h[j]);
        }
        PolynomialFunction[] polynomials = new PolynomialFunction[n];
        double[] coefficients = new double[4];
        for (int i = 0; i < n; ++i) {
            coefficients[0] = y[i];
            coefficients[1] = b[i];
            coefficients[2] = c[i];
            coefficients[3] = d[i];
            polynomials[i] = new PolynomialFunction(coefficients);
        }
        return new PolynomialSplineFunction(x, polynomials);
    }

    public <T extends CalculusFieldElement<T>> FieldPolynomialSplineFunction<T> interpolate(T[] x, T[] y) throws MathIllegalArgumentException {
        MathUtils.checkNotNull(x);
        MathUtils.checkNotNull(y);
        MathArrays.checkEqualLength(x, y);
        if (x.length < 3) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.NUMBER_OF_POINTS, x.length, 3, true);
        }
        int n = x.length - 1;
        MathArrays.checkOrder(x);
        Field field = x[0].getField();
        CalculusFieldElement[] h = (CalculusFieldElement[])MathArrays.buildArray(field, (int)n);
        for (int i = 0; i < n; ++i) {
            h[i] = (CalculusFieldElement)x[i + 1].subtract(x[i]);
        }
        CalculusFieldElement[] mu = (CalculusFieldElement[])MathArrays.buildArray(field, (int)n);
        CalculusFieldElement[] z = (CalculusFieldElement[])MathArrays.buildArray(field, (int)(n + 1));
        mu[0] = (CalculusFieldElement)field.getZero();
        z[0] = (CalculusFieldElement)field.getZero();
        for (int i = 1; i < n; ++i) {
            CalculusFieldElement g = ((CalculusFieldElement)((CalculusFieldElement)x[i + 1].subtract(x[i - 1])).multiply(2)).subtract(h[i - 1].multiply(mu[i - 1]));
            mu[i] = h[i].divide(g);
            z[i] = ((CalculusFieldElement)((CalculusFieldElement)y[i + 1].multiply((CalculusFieldElement)h[i - 1]).subtract(y[i].multiply(x[i + 1].subtract(x[i - 1])))).add(y[i - 1].multiply((CalculusFieldElement)h[i])).multiply(3)).divide(h[i - 1].multiply(h[i])).subtract(h[i - 1].multiply(z[i - 1])).divide(g);
        }
        CalculusFieldElement[] b = (CalculusFieldElement[])MathArrays.buildArray(field, (int)n);
        CalculusFieldElement[] c = (CalculusFieldElement[])MathArrays.buildArray(field, (int)(n + 1));
        CalculusFieldElement[] d = (CalculusFieldElement[])MathArrays.buildArray(field, (int)n);
        z[n] = (CalculusFieldElement)field.getZero();
        c[n] = (CalculusFieldElement)field.getZero();
        for (int j = n - 1; j >= 0; --j) {
            c[j] = z[j].subtract(mu[j].multiply(c[j + 1]));
            b[j] = (CalculusFieldElement)((CalculusFieldElement)y[j + 1].subtract(y[j])).divide(h[j]).subtract(h[j].multiply(c[j + 1].add(c[j]).add(c[j])).divide(3.0));
            d[j] = (CalculusFieldElement)c[j + 1].subtract(c[j]).divide(h[j].multiply(3));
        }
        FieldPolynomialFunction[] polynomials = (FieldPolynomialFunction[])Array.newInstance(FieldPolynomialFunction.class, n);
        CalculusFieldElement[] coefficients = (CalculusFieldElement[])MathArrays.buildArray(field, (int)4);
        for (int i = 0; i < n; ++i) {
            coefficients[0] = y[i];
            coefficients[1] = b[i];
            coefficients[2] = c[i];
            coefficients[3] = d[i];
            polynomials[i] = new FieldPolynomialFunction(coefficients);
        }
        return new FieldPolynomialSplineFunction(x, polynomials);
    }
}

