/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.events.handlers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.hipparchus.ode.events.Action;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.events.EventDetector;
import org.orekit.propagation.events.handlers.EventHandler;
import org.orekit.time.AbsoluteDate;

public class EventMultipleHandler<D extends EventDetector>
implements EventHandler<D> {
    private List<EventHandler<D>> handlers = new ArrayList<EventHandler<D>>();
    private List<EventHandler<D>> resetStateHandlers = new ArrayList<EventHandler<D>>();

    @Override
    public void init(SpacecraftState initialState, AbsoluteDate target) {
        this.handlers.forEach(handler -> handler.init(initialState, target));
    }

    @Override
    public Action eventOccurred(SpacecraftState s, D detector, boolean increasing) {
        Map actions = this.handlers.stream().collect(Collectors.toMap(Function.identity(), handler -> handler.eventOccurred(s, detector, increasing)));
        if (actions.containsValue(Action.STOP)) {
            return Action.STOP;
        }
        if (actions.containsValue(Action.RESET_STATE)) {
            this.resetStateHandlers = actions.entrySet().stream().filter(entry -> Action.RESET_STATE.equals(entry.getValue())).map(Map.Entry::getKey).collect(Collectors.toList());
            return Action.RESET_STATE;
        }
        if (actions.containsValue(Action.RESET_DERIVATIVES)) {
            return Action.RESET_DERIVATIVES;
        }
        if (actions.containsValue(Action.RESET_EVENTS)) {
            return Action.RESET_EVENTS;
        }
        return Action.CONTINUE;
    }

    @Override
    public SpacecraftState resetState(D detector, SpacecraftState oldState) {
        SpacecraftState newState = oldState;
        for (EventHandler<D> handler : this.resetStateHandlers) {
            newState = handler.resetState(detector, newState);
        }
        return newState;
    }

    public EventMultipleHandler<D> addHandler(EventHandler<D> handler) {
        this.handlers.add(handler);
        return this;
    }

    @SafeVarargs
    public final EventMultipleHandler<D> addHandlers(EventHandler<D> ... newHandlers) {
        Arrays.stream(newHandlers).forEach(this::addHandler);
        return this;
    }

    public void setHandlers(List<EventHandler<D>> newHandlers) {
        this.handlers = newHandlers;
    }

    public List<EventHandler<D>> getHandlers() {
        return this.handlers;
    }
}

