/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.analytical.gnss;

import org.hipparchus.RealFieldElement;
import org.hipparchus.analysis.differentiation.UnivariateDerivative2;
import org.hipparchus.exception.Localizable;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.MathUtils;
import org.hipparchus.util.Precision;
import org.orekit.attitudes.AttitudeProvider;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.frames.Frame;
import org.orekit.orbits.CartesianOrbit;
import org.orekit.orbits.Orbit;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.analytical.AbstractAnalyticalPropagator;
import org.orekit.propagation.analytical.gnss.GNSSOrbitalElements;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.PVCoordinates;

public abstract class AbstractGNSSPropagator
extends AbstractAnalyticalPropagator {
    private static final double A;
    private static final double B;
    private final GNSSOrbitalElements gnssOrbit;
    private final double av;
    private final double cycleDuration;
    private final double mass;
    private final double mu;
    private final Frame eci;
    private final Frame ecef;

    protected AbstractGNSSPropagator(GNSSOrbitalElements gnssOrbit, AttitudeProvider attitudeProvider, Frame eci, Frame ecef, double mass, double av, double cycleDuration, double mu) {
        super(attitudeProvider);
        this.gnssOrbit = gnssOrbit;
        this.av = av;
        this.cycleDuration = cycleDuration;
        this.mass = mass;
        this.mu = mu;
        this.eci = eci;
        this.ecef = ecef;
        this.setStartDate(gnssOrbit.getDate());
    }

    private double getTk(AbsoluteDate date) {
        double tk;
        for (tk = date.durationFrom(this.gnssOrbit.getDate()); tk > 0.5 * this.cycleDuration; tk -= this.cycleDuration) {
        }
        while (tk < -0.5 * this.cycleDuration) {
            tk += this.cycleDuration;
        }
        return tk;
    }

    public PVCoordinates propagateInEcef(AbsoluteDate date) {
        UnivariateDerivative2 tk = new UnivariateDerivative2(this.getTk(date), 1.0, 0.0);
        UnivariateDerivative2 mk = tk.multiply(this.gnssOrbit.getMeanMotion()).add(this.gnssOrbit.getM0());
        UnivariateDerivative2 ek = this.getEccentricAnomaly(mk);
        UnivariateDerivative2 vk = this.getTrueAnomaly(ek);
        UnivariateDerivative2 phik = vk.add(this.gnssOrbit.getPa());
        UnivariateDerivative2 twoPhik = phik.multiply(2);
        UnivariateDerivative2 c2phi = twoPhik.cos();
        UnivariateDerivative2 s2phi = twoPhik.sin();
        UnivariateDerivative2 dphik = c2phi.multiply(this.gnssOrbit.getCuc()).add(s2phi.multiply(this.gnssOrbit.getCus()));
        UnivariateDerivative2 drk = c2phi.multiply(this.gnssOrbit.getCrc()).add(s2phi.multiply(this.gnssOrbit.getCrs()));
        UnivariateDerivative2 dik = c2phi.multiply(this.gnssOrbit.getCic()).add(s2phi.multiply(this.gnssOrbit.getCis()));
        UnivariateDerivative2 uk = phik.add(dphik);
        UnivariateDerivative2 rk = ek.cos().multiply(-this.gnssOrbit.getE()).add(1.0).multiply(this.gnssOrbit.getSma()).add(drk);
        UnivariateDerivative2 ik = tk.multiply(this.gnssOrbit.getIDot()).add(this.gnssOrbit.getI0()).add(dik);
        UnivariateDerivative2 cik = ik.cos();
        UnivariateDerivative2 xk = uk.cos().multiply(rk);
        UnivariateDerivative2 yk = uk.sin().multiply(rk);
        UnivariateDerivative2 omk = tk.multiply(this.gnssOrbit.getOmegaDot() - this.av).add(this.gnssOrbit.getOmega0() - this.av * this.gnssOrbit.getTime());
        UnivariateDerivative2 comk = omk.cos();
        UnivariateDerivative2 somk = omk.sin();
        FieldVector3D positionwithDerivatives = new FieldVector3D((RealFieldElement)xk.multiply(comk).subtract(yk.multiply(somk).multiply(cik)), (RealFieldElement)xk.multiply(somk).add(yk.multiply(comk).multiply(cik)), (RealFieldElement)yk.multiply(ik.sin()));
        return new PVCoordinates(new Vector3D(((UnivariateDerivative2)positionwithDerivatives.getX()).getValue(), ((UnivariateDerivative2)positionwithDerivatives.getY()).getValue(), ((UnivariateDerivative2)positionwithDerivatives.getZ()).getValue()), new Vector3D(((UnivariateDerivative2)positionwithDerivatives.getX()).getFirstDerivative(), ((UnivariateDerivative2)positionwithDerivatives.getY()).getFirstDerivative(), ((UnivariateDerivative2)positionwithDerivatives.getZ()).getFirstDerivative()), new Vector3D(((UnivariateDerivative2)positionwithDerivatives.getX()).getSecondDerivative(), ((UnivariateDerivative2)positionwithDerivatives.getY()).getSecondDerivative(), ((UnivariateDerivative2)positionwithDerivatives.getZ()).getSecondDerivative()));
    }

    private UnivariateDerivative2 getEccentricAnomaly(UnivariateDerivative2 mk) {
        UnivariateDerivative2 ek;
        UnivariateDerivative2 reducedM = new UnivariateDerivative2(MathUtils.normalizeAngle((double)mk.getValue(), (double)0.0), mk.getFirstDerivative(), mk.getSecondDerivative());
        if (FastMath.abs((double)reducedM.getValue()) < 0.16666666666666666) {
            ek = FastMath.abs((double)reducedM.getValue()) < Precision.SAFE_MIN ? reducedM : reducedM.add(reducedM.multiply(6).cbrt().subtract(reducedM).multiply(this.gnssOrbit.getE()));
        } else if (reducedM.getValue() < 0.0) {
            UnivariateDerivative2 w = reducedM.add(Math.PI);
            ek = reducedM.add(w.multiply(-A).divide(w.subtract(B)).subtract(Math.PI).subtract(reducedM).multiply(this.gnssOrbit.getE()));
        } else {
            UnivariateDerivative2 minusW = reducedM.subtract(Math.PI);
            ek = reducedM.add(minusW.multiply(A).divide(minusW.add(B)).add(Math.PI).subtract(reducedM).multiply(this.gnssOrbit.getE()));
        }
        double e1 = 1.0 - this.gnssOrbit.getE();
        boolean noCancellationRisk = e1 + ek.getValue() * ek.getValue() / 6.0 >= 0.1;
        for (int j = 0; j < 2; ++j) {
            UnivariateDerivative2 fd;
            UnivariateDerivative2 f;
            UnivariateDerivative2 fdd = ek.sin().multiply(this.gnssOrbit.getE());
            UnivariateDerivative2 fddd = ek.cos().multiply(this.gnssOrbit.getE());
            if (noCancellationRisk) {
                f = ek.subtract(fdd).subtract(reducedM);
                fd = fddd.subtract(1.0).negate();
            } else {
                f = this.eMeSinE(ek).subtract(reducedM);
                UnivariateDerivative2 s = ek.multiply(0.5).sin();
                fd = s.multiply(s).multiply(2.0 * this.gnssOrbit.getE()).add(e1);
            }
            UnivariateDerivative2 dee = f.multiply(fd).divide(f.multiply(0.5).multiply(fdd).subtract(fd.multiply(fd)));
            UnivariateDerivative2 w = fd.add(dee.multiply(0.5).multiply(fdd.add(dee.multiply(fdd).divide(3.0))));
            fd = fd.add(dee.multiply(fdd.add(dee.multiply(0.5).multiply(fdd))));
            ek = ek.subtract(f.subtract(dee.multiply(fd.subtract(w))).divide(fd));
        }
        ek = ek.add(mk.getValue() - reducedM.getValue());
        return ek;
    }

    private UnivariateDerivative2 eMeSinE(UnivariateDerivative2 E) {
        UnivariateDerivative2 x = E.sin().multiply(1.0 - this.gnssOrbit.getE());
        UnivariateDerivative2 mE2 = E.negate().multiply(E);
        UnivariateDerivative2 term = E;
        UnivariateDerivative2 d = E.getField().getZero();
        UnivariateDerivative2 x0 = d.add(Double.NaN);
        while (!Double.valueOf(x.getValue()).equals(x0.getValue())) {
            d = d.add(2.0);
            term = term.multiply(mE2.divide(d.multiply(d.add(1.0))));
            x0 = x;
            x = x.subtract(term);
        }
        return x;
    }

    private UnivariateDerivative2 getTrueAnomaly(UnivariateDerivative2 ek) {
        UnivariateDerivative2 svk = ek.sin().multiply(FastMath.sqrt((double)(1.0 - this.gnssOrbit.getE() * this.gnssOrbit.getE())));
        UnivariateDerivative2 cvk = ek.cos().subtract(this.gnssOrbit.getE());
        return svk.atan2(cvk);
    }

    @Override
    protected Orbit propagateOrbit(AbsoluteDate date) {
        PVCoordinates pvaInECEF = this.propagateInEcef(date);
        PVCoordinates pvaInECI = this.ecef.getTransformTo(this.eci, date).transformPVCoordinates(pvaInECEF);
        return new CartesianOrbit(pvaInECI, this.eci, date, this.mu);
    }

    public double getMU() {
        return this.mu;
    }

    @Override
    public Frame getFrame() {
        return this.eci;
    }

    @Override
    protected double getMass(AbsoluteDate date) {
        return this.mass;
    }

    @Override
    public void resetInitialState(SpacecraftState state) {
        throw new OrekitException((Localizable)OrekitMessages.NON_RESETABLE_STATE, new Object[0]);
    }

    @Override
    protected void resetIntermediateState(SpacecraftState state, boolean forward) {
        throw new OrekitException((Localizable)OrekitMessages.NON_RESETABLE_STATE, new Object[0]);
    }

    public Frame getECI() {
        return this.eci;
    }

    public Frame getECEF() {
        return this.ecef;
    }

    static {
        double k1 = 11.42477796076938;
        double k2 = 2.141592653589793;
        double k3 = 17.84955592153876;
        A = 1.2043347651023166;
        B = 4.64788969626918;
    }
}

