/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.models.earth.troposphere;

import java.util.ArrayList;
import java.util.List;
import java.util.NavigableSet;
import org.hipparchus.RealFieldElement;
import org.hipparchus.util.MathArrays;
import org.orekit.annotation.DefaultDataContext;
import org.orekit.models.earth.troposphere.DiscreteTroposphericModel;
import org.orekit.models.earth.troposphere.EstimatedTroposphericModel;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.time.TimeScale;
import org.orekit.time.TimeScalesFactory;
import org.orekit.utils.ParameterDriver;
import org.orekit.utils.TimeSpanMap;

public class TimeSpanEstimatedTroposphericModel
implements DiscreteTroposphericModel {
    public static final String DATE_BEFORE = " - Before ";
    public static final String DATE_AFTER = " - After ";
    private final TimeScale timeScale;
    private final TimeSpanMap<EstimatedTroposphericModel> troposphericModelMap;

    @DefaultDataContext
    public TimeSpanEstimatedTroposphericModel(EstimatedTroposphericModel model) {
        this(model, TimeScalesFactory.getUTC());
    }

    public TimeSpanEstimatedTroposphericModel(EstimatedTroposphericModel model, TimeScale timeScale) {
        this.troposphericModelMap = new TimeSpanMap<EstimatedTroposphericModel>(model);
        this.timeScale = timeScale;
    }

    @Override
    public List<ParameterDriver> getParametersDrivers() {
        ArrayList<ParameterDriver> listTroposphericParameterDrivers = new ArrayList<ParameterDriver>();
        NavigableSet<TimeSpanMap.Transition<EstimatedTroposphericModel>> troposphericModelTransitions = this.getTransitions();
        for (TimeSpanMap.Transition<EstimatedTroposphericModel> transition : troposphericModelTransitions) {
            for (ParameterDriver tropoDriver : transition.getBefore().getParametersDrivers()) {
                if (this.findByName(listTroposphericParameterDrivers, tropoDriver.getName())) continue;
                listTroposphericParameterDrivers.add(tropoDriver);
            }
        }
        for (ParameterDriver tropoDriver : ((EstimatedTroposphericModel)((TimeSpanMap.Transition)troposphericModelTransitions.last()).getAfter()).getParametersDrivers()) {
            if (this.findByName(listTroposphericParameterDrivers, tropoDriver.getName())) continue;
            listTroposphericParameterDrivers.add(tropoDriver);
        }
        return listTroposphericParameterDrivers;
    }

    public void addTroposphericModelValidBefore(EstimatedTroposphericModel model, AbsoluteDate latestValidityDate) {
        this.troposphericModelMap.addValidBefore(this.changeTroposphericParameterDriversNames(model, latestValidityDate, DATE_BEFORE), latestValidityDate);
    }

    public void addTroposphericModelValidAfter(EstimatedTroposphericModel model, AbsoluteDate earliestValidityDate) {
        this.troposphericModelMap.addValidAfter(this.changeTroposphericParameterDriversNames(model, earliestValidityDate, DATE_AFTER), earliestValidityDate);
    }

    public EstimatedTroposphericModel getTroposphericModel(AbsoluteDate date) {
        return this.troposphericModelMap.get(date);
    }

    public NavigableSet<TimeSpanMap.Transition<EstimatedTroposphericModel>> getTransitions() {
        return this.troposphericModelMap.getTransitions();
    }

    public double[] extractParameters(double[] parameters, AbsoluteDate date) {
        List<ParameterDriver> troposphericParameterDriver = this.getTroposphericModel(date).getParametersDrivers();
        List<ParameterDriver> allTroposphericParameters = this.getParametersDrivers();
        double[] outParameters = new double[troposphericParameterDriver.size()];
        int index = 0;
        for (int i = 0; i < allTroposphericParameters.size(); ++i) {
            String driverName = allTroposphericParameters.get(i).getName();
            for (ParameterDriver tropoDriver : troposphericParameterDriver) {
                if (!tropoDriver.getName().equals(driverName)) continue;
                outParameters[index++] = parameters[i];
            }
        }
        return outParameters;
    }

    public <T extends RealFieldElement<T>> T[] extractParameters(T[] parameters, FieldAbsoluteDate<T> date) {
        List<ParameterDriver> troposphericParameterDriver = this.getTroposphericModel(date.toAbsoluteDate()).getParametersDrivers();
        List<ParameterDriver> allTroposphericParameters = this.getParametersDrivers();
        RealFieldElement[] outParameters = (RealFieldElement[])MathArrays.buildArray(date.getField(), (int)troposphericParameterDriver.size());
        int index = 0;
        for (int i = 0; i < allTroposphericParameters.size(); ++i) {
            String driverName = allTroposphericParameters.get(i).getName();
            for (ParameterDriver tropoDriver : troposphericParameterDriver) {
                if (!tropoDriver.getName().equals(driverName)) continue;
                outParameters[index++] = parameters[i];
            }
        }
        return outParameters;
    }

    @Override
    public double[] mappingFactors(double elevation, double height, double[] parameters, AbsoluteDate date) {
        double[] extractedParameters = this.extractParameters(parameters, date);
        return this.getTroposphericModel(date).mappingFactors(elevation, height, extractedParameters, date);
    }

    @Override
    public <T extends RealFieldElement<T>> T[] mappingFactors(T elevation, T height, T[] parameters, FieldAbsoluteDate<T> date) {
        RealFieldElement[] extractedParameters = this.extractParameters((RealFieldElement[])parameters, date);
        return this.getTroposphericModel(date.toAbsoluteDate()).mappingFactors(elevation, height, extractedParameters, date);
    }

    @Override
    public double pathDelay(double elevation, double height, double[] parameters, AbsoluteDate date) {
        double[] extractedParameters = this.extractParameters(parameters, date);
        return this.getTroposphericModel(date).pathDelay(elevation, height, extractedParameters, date);
    }

    @Override
    public <T extends RealFieldElement<T>> T pathDelay(T elevation, T height, T[] parameters, FieldAbsoluteDate<T> date) {
        RealFieldElement[] extractedParameters = this.extractParameters((RealFieldElement[])parameters, date);
        return (T)this.getTroposphericModel(date.toAbsoluteDate()).pathDelay(elevation, height, extractedParameters, date);
    }

    @Override
    public double[] computeZenithDelay(double height, double[] parameters, AbsoluteDate date) {
        double[] extractedParameters = this.extractParameters(parameters, date);
        return this.getTroposphericModel(date).computeZenithDelay(height, extractedParameters, date);
    }

    @Override
    public <T extends RealFieldElement<T>> T[] computeZenithDelay(T height, T[] parameters, FieldAbsoluteDate<T> date) {
        RealFieldElement[] extractedParameters = this.extractParameters((RealFieldElement[])parameters, date);
        return this.getTroposphericModel(date.toAbsoluteDate()).computeZenithDelay(height, extractedParameters, date);
    }

    private boolean findByName(List<ParameterDriver> driversList, String name) {
        for (ParameterDriver driver : driversList) {
            if (!driver.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    private EstimatedTroposphericModel changeTroposphericParameterDriversNames(EstimatedTroposphericModel troposphericModel, AbsoluteDate date, String datePrefix) {
        for (ParameterDriver driver : troposphericModel.getParametersDrivers()) {
            String driverName = driver.getName();
            if (!driverName.equals("total zenith delay")) continue;
            driver.setName(driverName + datePrefix + date.toString(this.timeScale));
        }
        return troposphericModel;
    }
}

