/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.models.earth.ionosphere;

import org.hipparchus.RealFieldElement;
import org.hipparchus.util.FastMath;
import org.orekit.models.earth.ionosphere.IonosphericMappingFunction;

public class SingleLayerModelMappingFunction
implements IonosphericMappingFunction {
    private static final double DEFAULT_HEIGHT = 450000.0;
    private static final double RE = 6371000.0;
    private final double hIon;

    public SingleLayerModelMappingFunction() {
        this(450000.0);
    }

    public SingleLayerModelMappingFunction(double hIon) {
        this.hIon = hIon;
    }

    @Override
    public double mappingFactor(double elevation) {
        double z = FastMath.abs((double)(1.5707963267948966 - elevation));
        double ratio = 6371000.0 / (6371000.0 + this.hIon);
        double coef = FastMath.sin((double)z) * ratio;
        return 1.0 / FastMath.sqrt((double)(1.0 - coef * coef));
    }

    @Override
    public <T extends RealFieldElement<T>> T mappingFactor(T elevation) {
        RealFieldElement z = FastMath.abs((RealFieldElement)((RealFieldElement)((RealFieldElement)elevation.negate()).add(1.5707963267948966)));
        double ratio = 6371000.0 / (6371000.0 + this.hIon);
        RealFieldElement coef = (RealFieldElement)FastMath.sin((RealFieldElement)z).multiply(ratio);
        return (T)((RealFieldElement)FastMath.sqrt((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)coef.multiply((Object)coef)).negate()).add(1.0))).reciprocal());
    }
}

