/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.models.earth.displacement;

import org.orekit.data.BodiesElements;

public class Tide {
    public static final Tide M2 = new Tide(255555);
    public static final Tide S2 = new Tide(273555);
    public static final Tide N2 = new Tide(245655);
    public static final Tide K2 = new Tide(275555);
    public static final Tide K1 = new Tide(165555);
    public static final Tide O1 = new Tide(145555);
    public static final Tide P1 = new Tide(163555);
    public static final Tide Q1 = new Tide(135655);
    public static final Tide MF = new Tide(75555);
    public static final Tide MM = new Tide(65455);
    public static final Tide SSA = new Tide(57555);
    private final int doodsonNumber;
    private final int[] doodsonMultipliers;
    private final int[] delaunayMultipliers;

    public Tide(int cTau, int cS, int cH, int cP, int cNprime, int cPs) {
        this.doodsonNumber = Tide.doodsonMultipliersToDoodsonNumber(cTau, cS, cH, cP, cNprime, cPs);
        this.doodsonMultipliers = new int[]{cTau, cS, cH, cP, cNprime, cPs};
        this.delaunayMultipliers = Tide.doodsonMultipliersToDelaunayMultipliers(this.doodsonMultipliers);
    }

    public Tide(int doodsonNumber) {
        this.doodsonNumber = doodsonNumber;
        this.doodsonMultipliers = Tide.doodsonNumberToDoodsonMultipliers(doodsonNumber);
        this.delaunayMultipliers = Tide.doodsonMultipliersToDelaunayMultipliers(this.doodsonMultipliers);
    }

    private static int[] doodsonNumberToDoodsonMultipliers(int doodsonNumber) {
        return new int[]{doodsonNumber / 100000 % 10, doodsonNumber / 10000 % 10 - 5, doodsonNumber / 1000 % 10 - 5, doodsonNumber / 100 % 10 - 5, doodsonNumber / 10 % 10 - 5, doodsonNumber % 10 - 5};
    }

    private static int doodsonMultipliersToDoodsonNumber(int cTau, int cS, int cH, int cP, int cNprime, int cPs) {
        return ((((cTau * 10 + (cS + 5)) * 10 + (cH + 5)) * 10 + (cP + 5)) * 10 + (cNprime + 5)) * 10 + (cPs + 5);
    }

    private static int[] doodsonMultipliersToDelaunayMultipliers(int[] dom) {
        return new int[]{dom[3], dom[5], dom[0] - dom[1] - dom[2] - dom[3] - dom[5], dom[2] + dom[5], dom[0] - dom[1] - dom[2] - dom[3] + dom[4] - dom[5]};
    }

    public int[] getDelaunayMultipliers() {
        return (int[])this.delaunayMultipliers.clone();
    }

    public int[] getDoodsonMultipliers() {
        return (int[])this.doodsonMultipliers.clone();
    }

    public int getDoodsonNumber() {
        return this.doodsonNumber;
    }

    public int getTauMultiplier() {
        return this.doodsonMultipliers[0];
    }

    public double getPhase(BodiesElements elements) {
        return (double)this.doodsonMultipliers[0] * elements.getGamma() - (double)this.delaunayMultipliers[0] * elements.getL() - (double)this.delaunayMultipliers[1] * elements.getLPrime() - (double)this.delaunayMultipliers[2] * elements.getF() - (double)this.delaunayMultipliers[3] * elements.getD() - (double)this.delaunayMultipliers[4] * elements.getOmega();
    }

    public double getRate(BodiesElements elements) {
        return (double)this.doodsonMultipliers[0] * elements.getGammaDot() - (double)this.delaunayMultipliers[0] * elements.getLDot() - (double)this.delaunayMultipliers[1] * elements.getLPrimeDot() - (double)this.delaunayMultipliers[2] * elements.getFDot() - (double)this.delaunayMultipliers[3] * elements.getDDot() - (double)this.delaunayMultipliers[4] * elements.getOmegaDot();
    }

    public boolean equals(Object object) {
        if (object instanceof Tide) {
            return this.doodsonNumber == ((Tide)object).doodsonNumber;
        }
        return false;
    }

    public int hashCode() {
        return this.doodsonNumber;
    }
}

