/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.models.earth.displacement;

import org.hipparchus.geometry.Vector;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.util.FastMath;
import org.orekit.data.BodiesElements;
import org.orekit.data.PoissonSeries;
import org.orekit.frames.Frame;
import org.orekit.models.earth.displacement.StationDisplacement;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.IERSConventions;
import org.orekit.utils.PVCoordinatesProvider;

public class TidalDisplacement
implements StationDisplacement {
    private final PVCoordinatesProvider sun;
    private final PVCoordinatesProvider moon;
    private final boolean removePermanentDeformation;
    private final double ratio2S;
    private final double ratio3S;
    private final double ratio2M;
    private final double ratio3M;
    private final double hSup0;
    private final double hSup2;
    private final double h3;
    private final double hIDiurnal;
    private final double hISemiDiurnal;
    private final double lSup0;
    private final double lSup1Diurnal;
    private final double lSup1SemiDiurnal;
    private final double lSup2;
    private final double l3;
    private final double lIDiurnal;
    private final double lISemiDiurnal;
    private final double h0Permanent;
    private final PoissonSeries.CompiledSeries frequencyCorrectionDiurnal;
    private final PoissonSeries.CompiledSeries frequencyCorrectionZonal;

    public TidalDisplacement(double rEarth, double sunEarthSystemMassRatio, double earthMoonMassRatio, PVCoordinatesProvider sun, PVCoordinatesProvider moon, IERSConventions conventions, boolean removePermanentDeformation) {
        double sunEarthMassRatio = sunEarthSystemMassRatio * (1.0 + 1.0 / earthMoonMassRatio);
        double moonEarthMassRatio = 1.0 / earthMoonMassRatio;
        this.sun = sun;
        this.moon = moon;
        this.removePermanentDeformation = removePermanentDeformation;
        double r2 = rEarth * rEarth;
        double r4 = r2 * r2;
        this.ratio2S = r4 * sunEarthMassRatio;
        this.ratio3S = this.ratio2S * rEarth;
        this.ratio2M = r4 * moonEarthMassRatio;
        this.ratio3M = this.ratio2M * rEarth;
        double[] hl = conventions.getNominalTidalDisplacement();
        this.hSup0 = hl[0];
        this.hSup2 = hl[1];
        this.h3 = hl[2];
        this.hIDiurnal = hl[3];
        this.hISemiDiurnal = hl[4];
        this.lSup0 = hl[5];
        this.lSup1Diurnal = hl[6];
        this.lSup1SemiDiurnal = hl[7];
        this.lSup2 = hl[8];
        this.l3 = hl[9];
        this.lIDiurnal = hl[10];
        this.lISemiDiurnal = hl[11];
        this.h0Permanent = hl[12];
        this.frequencyCorrectionDiurnal = conventions.getTidalDisplacementFrequencyCorrectionDiurnal();
        this.frequencyCorrectionZonal = conventions.getTidalDisplacementFrequencyCorrectionZonal();
    }

    @Override
    public Vector3D displacement(BodiesElements elements, Frame earthFrame, Vector3D referencePoint) {
        AbsoluteDate date = elements.getDate();
        PointData pointData = new PointData(referencePoint);
        Vector3D sunPosition = this.sun.getPVCoordinates(date, earthFrame).getPosition();
        BodyData sunData = new BodyData(sunPosition, this.ratio2S, this.ratio3S, pointData);
        Vector3D moonPosition = this.moon.getPVCoordinates(date, earthFrame).getPosition();
        BodyData moonData = new BodyData(moonPosition, this.ratio2M, this.ratio3M, pointData);
        Vector3D displacement = this.timeDomainCorrection(pointData, sunData, moonData);
        displacement = displacement.add((Vector)this.frequencyDomainCorrection(elements, pointData));
        if (this.removePermanentDeformation) {
            displacement = displacement.subtract((Vector)this.permanentDeformation(pointData));
        }
        return displacement;
    }

    private Vector3D timeDomainCorrection(PointData pointData, BodyData sunData, BodyData moonData) {
        double h2 = this.hSup0 + this.hSup2 * pointData.f;
        double l2 = this.lSup0 + this.lSup2 * pointData.f;
        double s2R = sunData.factor2 * 3.0 * l2 * sunData.dot;
        double s2r = sunData.factor2 * 0.5 * h2 * (3.0 * sunData.dot2 - 1.0) - s2R * sunData.dot;
        double m2R = moonData.factor2 * 3.0 * l2 * moonData.dot;
        double m2r = moonData.factor2 * 0.5 * h2 * (3.0 * moonData.dot2 - 1.0) - m2R * moonData.dot;
        double s3R = sunData.factor3 * this.l3 * (7.5 * sunData.dot2 - 1.5);
        double s3r = sunData.factor3 * this.h3 * sunData.dot * (2.5 * sunData.dot2 - 1.5) - s3R * sunData.dot;
        double m3R = moonData.factor3 * this.l3 * (7.5 * moonData.dot2 - 1.5);
        double m3r = moonData.factor3 * this.h3 * moonData.dot * (2.5 * moonData.dot2 - 1.5) - m3R * moonData.dot;
        Vector3D inPhaseDisplacement = new Vector3D(s2r + m2r + s3r + m3r, pointData.radial, (s2R + s3R) / sunData.r, sunData.position, (m2R + m3R) / moonData.r, moonData.position);
        double drOd = -0.75 * this.hIDiurnal * pointData.sin2Phi * (sunData.factor2 * sunData.sin2Phi * sunData.sinDeltaLambda + moonData.factor2 * moonData.sin2Phi * moonData.sinDeltaLambda);
        double dnOd = -1.5 * this.lIDiurnal * pointData.cos2Phi * (sunData.factor2 * sunData.sin2Phi * sunData.sinDeltaLambda + moonData.factor2 * moonData.sin2Phi * moonData.sinDeltaLambda);
        double deOd = -1.5 * this.lIDiurnal * pointData.sinPhi * (sunData.factor2 * sunData.sin2Phi * sunData.cosDeltaLambda + moonData.factor2 * moonData.sin2Phi * moonData.cosDeltaLambda);
        double drOsd = -0.75 * this.hISemiDiurnal * pointData.cosPhi2 * (sunData.factor2 * sunData.cosPhi2 * sunData.sin2DeltaLambda + moonData.factor2 * moonData.cosPhi2 * moonData.sin2DeltaLambda);
        double dnOsd = 0.75 * this.lISemiDiurnal * pointData.sin2Phi * (sunData.factor2 * sunData.cosPhi2 * sunData.sin2DeltaLambda + moonData.factor2 * moonData.cosPhi2 * moonData.sin2DeltaLambda);
        double deOsd = -1.5 * this.lISemiDiurnal * pointData.cosPhi * (sunData.factor2 * sunData.cosPhi2 * sunData.cos2DeltaLambda + moonData.factor2 * moonData.cosPhi2 * moonData.cos2DeltaLambda);
        double dnLd = -this.lSup1Diurnal * pointData.sinPhi2 * (sunData.factor2 * sunData.p21 * sunData.cosDeltaLambda + moonData.factor2 * moonData.p21 * moonData.cosDeltaLambda);
        double deLd = this.lSup1Diurnal * pointData.sinPhi * pointData.cos2Phi * (sunData.factor2 * sunData.p21 * sunData.sinDeltaLambda + moonData.factor2 * moonData.p21 * moonData.sinDeltaLambda);
        double dnLsd = -0.25 * this.lSup1SemiDiurnal * pointData.sin2Phi * (sunData.factor2 * sunData.p22 * sunData.cos2DeltaLambda + moonData.factor2 * moonData.p22 * moonData.cos2DeltaLambda);
        double deLsd = -0.25 * this.lSup1SemiDiurnal * pointData.sin2Phi * pointData.sinPhi * (sunData.factor2 * sunData.p22 * sunData.sin2DeltaLambda + moonData.factor2 * moonData.p22 * moonData.sin2DeltaLambda);
        Vector3D outOfPhaseDisplacement = new Vector3D(drOd + drOsd, pointData.radial, dnOd + dnOsd + dnLd + dnLsd, pointData.north, deOd + deOsd + deLd + deLsd, pointData.east);
        return inPhaseDisplacement.add((Vector)outOfPhaseDisplacement);
    }

    private Vector3D frequencyDomainCorrection(BodiesElements elements, PointData pointData) {
        double[] cD = this.frequencyCorrectionDiurnal.value(elements);
        double drD = pointData.sin2Phi * (cD[0] * pointData.cosLambda + cD[1] * pointData.sinLambda);
        double dnD = pointData.cos2Phi * (cD[2] * pointData.cosLambda + cD[3] * pointData.sinLambda);
        double deD = pointData.sinPhi * (cD[4] * pointData.cosLambda + cD[5] * pointData.sinLambda);
        double[] cZ = this.frequencyCorrectionZonal.value(elements);
        double drZ = (1.5 * pointData.sinPhi2 - 0.5) * cZ[0];
        double dnZ = pointData.sin2Phi * cZ[1];
        return new Vector3D(drD + drZ, pointData.radial, dnD + dnZ, pointData.north, deD, pointData.east);
    }

    private Vector3D permanentDeformation(PointData pointData) {
        double h2 = this.hSup0 + this.hSup2 * pointData.f;
        double l2 = this.lSup0 + this.lSup2 * pointData.f;
        double factor = FastMath.sqrt((double)0.3978873577297384);
        double dr = factor * h2 * this.h0Permanent * pointData.f;
        double dn = factor * 1.5 * l2 * this.h0Permanent * pointData.sin2Phi;
        return new Vector3D(dr, pointData.radial, dn, pointData.north);
    }

    private static class BodyData {
        private final Vector3D position;
        private final double r;
        private final double dot;
        private final double dot2;
        private final double factor2;
        private final double factor3;
        private final double cosPhi2;
        private final double sin2Phi;
        private final double p21;
        private final double p22;
        private final double sinDeltaLambda;
        private final double cosDeltaLambda;
        private final double sin2DeltaLambda;
        private final double cos2DeltaLambda;

        BodyData(Vector3D position, double ratio2, double ratio3, PointData pointData) {
            double x = position.getX();
            double y = position.getY();
            double z = position.getZ();
            double x2 = x * x;
            double y2 = y * y;
            double z2 = z * z;
            this.position = position;
            double r2 = x2 + y2 + z2;
            this.r = FastMath.sqrt((double)r2);
            this.dot = Vector3D.dotProduct((Vector3D)position, (Vector3D)pointData.position) / (this.r * pointData.r);
            this.dot2 = this.dot * this.dot;
            this.factor2 = ratio2 / (r2 * this.r);
            this.factor3 = ratio3 / (r2 * r2);
            double rho = FastMath.sqrt((double)(x2 + y2));
            double sinPhi = z / this.r;
            double cosPhi = rho / this.r;
            double sinCos = sinPhi * cosPhi;
            this.cosPhi2 = cosPhi * cosPhi;
            this.sin2Phi = 2.0 * sinCos;
            this.p21 = 3.0 * sinCos;
            this.p22 = 3.0 * this.cosPhi2;
            double sinLambda = y / rho;
            double cosLambda = x / rho;
            this.sinDeltaLambda = pointData.sinLambda * cosLambda - pointData.cosLambda * sinLambda;
            this.cosDeltaLambda = pointData.cosLambda * cosLambda + pointData.sinLambda * sinLambda;
            this.sin2DeltaLambda = 2.0 * this.sinDeltaLambda * this.cosDeltaLambda;
            this.cos2DeltaLambda = this.cosDeltaLambda * this.cosDeltaLambda - this.sinDeltaLambda * this.sinDeltaLambda;
        }
    }

    private static class PointData {
        private final Vector3D position;
        private final double r;
        private final double sinPhi;
        private final double cosPhi;
        private final double sinPhi2;
        private final double cosPhi2;
        private final double sin2Phi;
        private final double cos2Phi;
        private final double sinLambda;
        private final double cosLambda;
        private final Vector3D radial;
        private final Vector3D north;
        private final Vector3D east;
        private final double f;

        PointData(Vector3D position) {
            this.position = position;
            double x = position.getX();
            double y = position.getY();
            double z = position.getZ();
            double x2 = x * x;
            double y2 = y * y;
            double z2 = z * z;
            double rho2 = x2 + y2;
            double rho = FastMath.sqrt((double)rho2);
            double r2 = rho2 + z2;
            this.r = FastMath.sqrt((double)r2);
            this.sinPhi = z / this.r;
            this.cosPhi = rho / this.r;
            this.sinPhi2 = this.sinPhi * this.sinPhi;
            this.cosPhi2 = this.cosPhi * this.cosPhi;
            this.sin2Phi = 2.0 * this.sinPhi * this.cosPhi;
            this.cos2Phi = this.cosPhi2 - this.sinPhi2;
            if (rho == 0.0) {
                this.sinLambda = 0.0;
                this.cosLambda = 1.0;
            } else {
                this.sinLambda = y / rho;
                this.cosLambda = x / rho;
            }
            this.radial = new Vector3D(x / this.r, y / this.r, this.sinPhi);
            this.north = new Vector3D(-this.cosLambda * this.sinPhi, -this.sinLambda * this.sinPhi, this.cosPhi);
            this.east = new Vector3D(-this.sinLambda, this.cosLambda, 0.0);
            this.f = (z2 - 0.5 * rho2) / r2;
        }
    }
}

