/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.models.earth;

import org.hipparchus.util.FastMath;
import org.orekit.bodies.OneAxisEllipsoid;
import org.orekit.frames.Frame;
import org.orekit.models.earth.EarthShape;

public class ReferenceEllipsoid
extends OneAxisEllipsoid
implements EarthShape {
    private static final long serialVersionUID = 20150311L;
    private final double GM;
    private final double spin;

    public ReferenceEllipsoid(double ae, double f, Frame bodyFrame, double GM, double spin) {
        super(ae, f, bodyFrame);
        this.GM = GM;
        this.spin = spin;
    }

    public double getGM() {
        return this.GM;
    }

    public double getSpin() {
        return this.spin;
    }

    public double getPolarRadius() {
        double a = this.getEquatorialRadius();
        double f = this.getFlattening();
        return a - f * a;
    }

    public double getNormalGravity(double latitude) {
        double a = this.getEquatorialRadius();
        double f = this.getFlattening();
        double b = a * (1.0 - f);
        double a2 = a * a;
        double b2 = b * b;
        double E = FastMath.sqrt((double)(a2 - b2));
        double e = E / a;
        double eprime = E / b;
        double m = this.spin * this.spin * a2 * b / this.GM;
        double ya = this.GM / (a * b) * (1.0 - 1.5 * m - 0.21428571428571427 * eprime * m);
        double yb = this.GM / a2 * (1.0 + m + 0.42857142857142855 * eprime * m);
        double kappa = (b * yb - a * ya) / (a * ya);
        double sin = FastMath.sin((double)latitude);
        double sin2 = sin * sin;
        return ya * (1.0 + kappa * sin2) / FastMath.sqrt((double)(1.0 - e * e * sin2));
    }

    public double getC2n0(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("Expected n < 1, got n=" + n);
        }
        double a = this.getEquatorialRadius();
        double f = this.getFlattening();
        double b = a * (1.0 - f);
        double a2 = a * a;
        double b2 = b * b;
        double E = FastMath.sqrt((double)(a2 - b2));
        double e = E / a;
        double m = this.spin * this.spin * a2 * b / this.GM;
        double J2 = 0.6666666666666666 * f - 0.3333333333333333 * m - 0.3333333333333333 * f * f + 0.09523809523809523 * f * m;
        double C2 = -J2 / FastMath.sqrt((double)5.0);
        return (double)((n & 1) == 0 ? 3 : -3) * FastMath.pow((double)e, (int)(2 * n)) * ((double)(1 - n) - FastMath.pow((double)5.0, (double)1.5) * (double)n * C2 / (e * e)) / ((double)((2 * n + 1) * (2 * n + 3)) * FastMath.sqrt((double)(4 * n + 1)));
    }

    @Override
    public ReferenceEllipsoid getEllipsoid() {
        return this;
    }

    public static ReferenceEllipsoid getWgs84(Frame bodyFrame) {
        return new ReferenceEllipsoid(6378137.0, 0.0033528106647474805, bodyFrame, 3.986004418E14, 7.292115E-5);
    }

    public static ReferenceEllipsoid getGrs80(Frame bodyFrame) {
        return new ReferenceEllipsoid(6378137.0, 0.003352810681182319, bodyFrame, 3.986005E14, 7.292115E-5);
    }

    public static ReferenceEllipsoid getIers96(Frame bodyFrame) {
        return new ReferenceEllipsoid(6378136.49, 0.003352819697896193, bodyFrame, 3.986004418E14, 7.292115E-5);
    }

    public static ReferenceEllipsoid getIers2003(Frame bodyFrame) {
        return new ReferenceEllipsoid(6378136.6, 0.003352819697896193, bodyFrame, 3.986004418E14, 7.292115E-5);
    }

    public static ReferenceEllipsoid getIers2010(Frame bodyFrame) {
        return new ReferenceEllipsoid(6378136.6, 0.003352819697896193, bodyFrame, 3.986004418E14, 7.292115E-5);
    }
}

