/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.gnss.antenna;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.hipparchus.exception.Localizable;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.gnss.Frequency;
import org.orekit.gnss.antenna.FrequencyPattern;

public class Antenna {
    private final String type;
    private final String sinexCode;
    private final Map<Frequency, FrequencyPattern> patterns;

    protected Antenna(String type, String sinexCode, Map<Frequency, FrequencyPattern> patterns) {
        this.type = type;
        this.sinexCode = sinexCode;
        this.patterns = patterns;
    }

    public String getType() {
        return this.type;
    }

    public String getSinexCode() {
        return this.sinexCode;
    }

    public List<Frequency> getFrequencies() {
        return this.patterns.entrySet().stream().map(e -> (Frequency)((Object)((Object)e.getKey()))).collect(Collectors.toList());
    }

    public Vector3D getEccentricities(Frequency frequency) {
        return this.getPattern(frequency).getEccentricities();
    }

    public double getPhaseCenterVariation(Frequency frequency, Vector3D direction) {
        return this.getPattern(frequency).getPhaseCenterVariation(direction);
    }

    private FrequencyPattern getPattern(Frequency frequency) {
        FrequencyPattern pattern = this.patterns.get((Object)frequency);
        if (pattern == null) {
            throw new OrekitException((Localizable)OrekitMessages.UNSUPPORTED_FREQUENCY_FOR_ANTENNA, new Object[]{frequency, this.type});
        }
        return pattern;
    }
}

