/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.forces.maneuvers.propulsion;

import org.hipparchus.RealFieldElement;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.orekit.attitudes.Attitude;
import org.orekit.attitudes.FieldAttitude;
import org.orekit.forces.maneuvers.propulsion.PropulsionModel;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.SpacecraftState;

public interface ThrustPropulsionModel
extends PropulsionModel {
    default public double getIsp(SpacecraftState s) {
        double thrust = this.getThrust(s);
        double flowRate = this.getFlowRate(s);
        return -thrust / (9.80665 * flowRate);
    }

    default public Vector3D getDirection(SpacecraftState s) {
        return this.getThrustVector(s).normalize();
    }

    default public double getThrust(SpacecraftState s) {
        return this.getThrustVector(s).getNorm();
    }

    public Vector3D getThrustVector(SpacecraftState var1);

    public double getFlowRate(SpacecraftState var1);

    public Vector3D getThrustVector(SpacecraftState var1, double[] var2);

    public double getFlowRate(SpacecraftState var1, double[] var2);

    public <T extends RealFieldElement<T>> FieldVector3D<T> getThrustVector(FieldSpacecraftState<T> var1, T[] var2);

    public <T extends RealFieldElement<T>> T getFlowRate(FieldSpacecraftState<T> var1, T[] var2);

    @Override
    default public Vector3D getAcceleration(SpacecraftState s, Attitude maneuverAttitude, double[] parameters) {
        Vector3D thrustVector = this.getThrustVector(s, parameters);
        double thrust = thrustVector.getNorm();
        Vector3D direction = thrustVector.normalize();
        return new Vector3D(thrust / s.getMass(), maneuverAttitude.getRotation().applyInverseTo(direction));
    }

    @Override
    default public <T extends RealFieldElement<T>> FieldVector3D<T> getAcceleration(FieldSpacecraftState<T> s, FieldAttitude<T> maneuverAttitude, T[] parameters) {
        FieldVector3D thrustVector = this.getThrustVector(s, (RealFieldElement[])parameters);
        RealFieldElement thrust = thrustVector.getNorm();
        FieldVector3D direction = thrustVector.normalize();
        return new FieldVector3D((RealFieldElement)((RealFieldElement)s.getMass().reciprocal()).multiply((Object)thrust), maneuverAttitude.getRotation().applyInverseTo(direction));
    }

    @Override
    default public double getMassDerivatives(SpacecraftState s, double[] parameters) {
        return this.getFlowRate(s, parameters);
    }

    @Override
    default public <T extends RealFieldElement<T>> T getMassDerivatives(FieldSpacecraftState<T> s, T[] parameters) {
        return (T)this.getFlowRate(s, (RealFieldElement[])parameters);
    }
}

