/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.forces.maneuvers.propulsion;

import org.hipparchus.RealFieldElement;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.util.FastMath;
import org.orekit.forces.maneuvers.propulsion.AbstractConstantThrustPropulsionModel;
import org.orekit.utils.ParameterDriver;

public class ScaledConstantThrustPropulsionModel
extends AbstractConstantThrustPropulsionModel {
    public static final String THRUSTX_SCALE_FACTOR = "TX scale factor";
    public static final String THRUSTY_SCALE_FACTOR = "TY scale factor";
    public static final String THRUSTZ_SCALE_FACTOR = "TZ scale factor";
    private static final double THRUST_SCALE = FastMath.scalb((double)1.0, (int)-5);
    private final ParameterDriver scaleFactorThrustXDriver;
    private final ParameterDriver scaleFactorThrustYDriver;
    private final ParameterDriver scaleFactorThrustZDriver;

    public ScaledConstantThrustPropulsionModel(double thrust, double isp, Vector3D direction, String name) {
        super(thrust, isp, direction, name);
        this.scaleFactorThrustXDriver = new ParameterDriver(name + THRUSTX_SCALE_FACTOR, 1.0, THRUST_SCALE, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
        this.scaleFactorThrustYDriver = new ParameterDriver(name + THRUSTY_SCALE_FACTOR, 1.0, THRUST_SCALE, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
        this.scaleFactorThrustZDriver = new ParameterDriver(name + THRUSTZ_SCALE_FACTOR, 1.0, THRUST_SCALE, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
    }

    private Vector3D getThrustVector(double scaleFactorX, double scaleFactorY, double scaleFactorZ) {
        return new Vector3D(this.getInitialThrustVector().getX() * scaleFactorX, this.getInitialThrustVector().getY() * scaleFactorY, this.getInitialThrustVector().getZ() * scaleFactorZ);
    }

    @Override
    public Vector3D getThrustVector() {
        return this.getThrustVector(this.scaleFactorThrustXDriver.getValue(), this.scaleFactorThrustYDriver.getValue(), this.scaleFactorThrustZDriver.getValue());
    }

    @Override
    public double getFlowRate() {
        return this.getInitialFlowrate();
    }

    @Override
    public ParameterDriver[] getParametersDrivers() {
        return new ParameterDriver[]{this.scaleFactorThrustXDriver, this.scaleFactorThrustYDriver, this.scaleFactorThrustZDriver};
    }

    @Override
    public Vector3D getThrustVector(double[] parameters) {
        return this.getThrustVector(parameters[0], parameters[1], parameters[2]);
    }

    @Override
    public double getFlowRate(double[] parameters) {
        return this.getInitialFlowrate();
    }

    @Override
    public <T extends RealFieldElement<T>> FieldVector3D<T> getThrustVector(T[] parameters) {
        return new FieldVector3D((RealFieldElement)parameters[0].multiply(this.getInitialThrustVector().getX()), (RealFieldElement)parameters[1].multiply(this.getInitialThrustVector().getY()), (RealFieldElement)parameters[2].multiply(this.getInitialThrustVector().getZ()));
    }

    @Override
    public <T extends RealFieldElement<T>> T getFlowRate(T[] parameters) {
        return (T)((RealFieldElement)((RealFieldElement)parameters[0].getField().getZero()).add(this.getInitialFlowrate()));
    }
}

