/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.forces.maneuvers;

import java.util.Map;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.ode.events.Action;
import org.hipparchus.util.FastMath;
import org.orekit.attitudes.Attitude;
import org.orekit.attitudes.AttitudeProvider;
import org.orekit.orbits.CartesianOrbit;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.events.AbstractDetector;
import org.orekit.propagation.events.EventDetector;
import org.orekit.propagation.events.handlers.EventHandler;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.PVCoordinates;
import org.orekit.utils.TimeStampedPVCoordinates;

public class ImpulseManeuver<T extends EventDetector>
extends AbstractDetector<ImpulseManeuver<T>> {
    private final AttitudeProvider attitudeOverride;
    private final T trigger;
    private final Vector3D deltaVSat;
    private final double isp;
    private final double vExhaust;
    private boolean forward;

    public ImpulseManeuver(T trigger, Vector3D deltaVSat, double isp) {
        this(trigger.getMaxCheckInterval(), trigger.getThreshold(), trigger.getMaxIterationCount(), new Handler(), trigger, null, deltaVSat, isp);
    }

    public ImpulseManeuver(T trigger, AttitudeProvider attitudeOverride, Vector3D deltaVSat, double isp) {
        this(trigger.getMaxCheckInterval(), trigger.getThreshold(), trigger.getMaxIterationCount(), new Handler(), trigger, attitudeOverride, deltaVSat, isp);
    }

    private ImpulseManeuver(double maxCheck, double threshold, int maxIter, EventHandler<? super ImpulseManeuver<T>> handler, T trigger, AttitudeProvider attitudeOverride, Vector3D deltaVSat, double isp) {
        super(maxCheck, threshold, maxIter, handler);
        this.attitudeOverride = attitudeOverride;
        this.trigger = trigger;
        this.deltaVSat = deltaVSat;
        this.isp = isp;
        this.vExhaust = 9.80665 * isp;
    }

    @Override
    protected ImpulseManeuver<T> create(double newMaxCheck, double newThreshold, int newMaxIter, EventHandler<? super ImpulseManeuver<T>> newHandler) {
        return new ImpulseManeuver<T>(newMaxCheck, newThreshold, newMaxIter, newHandler, this.trigger, this.attitudeOverride, this.deltaVSat, this.isp);
    }

    @Override
    public void init(SpacecraftState s0, AbsoluteDate t) {
        this.forward = t.durationFrom(s0.getDate()) >= 0.0;
        this.trigger.init(s0, t);
    }

    @Override
    public double g(SpacecraftState s) {
        return this.trigger.g(s);
    }

    public AttitudeProvider getAttitudeOverride() {
        return this.attitudeOverride;
    }

    public T getTrigger() {
        return this.trigger;
    }

    public Vector3D getDeltaVSat() {
        return this.deltaVSat;
    }

    public double getIsp() {
        return this.isp;
    }

    private static class Handler<T extends EventDetector>
    implements EventHandler<ImpulseManeuver<T>> {
        private Handler() {
        }

        @Override
        public Action eventOccurred(SpacecraftState s, ImpulseManeuver<T> im, boolean increasing) {
            Action underlyingAction = ((ImpulseManeuver)im).trigger.eventOccurred(s, increasing);
            return underlyingAction == Action.STOP ? Action.RESET_STATE : Action.CONTINUE;
        }

        @Override
        public SpacecraftState resetState(ImpulseManeuver<T> im, SpacecraftState oldState) {
            AbsoluteDate date = oldState.getDate();
            AttitudeProvider override = im.getAttitudeOverride();
            Attitude attitude = override == null ? oldState.getAttitude() : override.getAttitude(oldState.getOrbit(), date, oldState.getFrame());
            Vector3D deltaV = attitude.getRotation().applyInverseTo(((ImpulseManeuver)im).deltaVSat);
            double sign = ((ImpulseManeuver)im).forward ? 1.0 : -1.0;
            TimeStampedPVCoordinates oldPV = oldState.getPVCoordinates();
            PVCoordinates newPV = new PVCoordinates(oldPV.getPosition(), new Vector3D(1.0, oldPV.getVelocity(), sign, deltaV));
            CartesianOrbit newOrbit = new CartesianOrbit(newPV, oldState.getFrame(), date, oldState.getMu());
            double newMass = oldState.getMass() * FastMath.exp((double)(-sign * deltaV.getNorm() / ((ImpulseManeuver)im).vExhaust));
            SpacecraftState newState = new SpacecraftState(oldState.getOrbit().getType().convertType(newOrbit), attitude, newMass);
            for (Map.Entry<String, double[]> entry : oldState.getAdditionalStates().entrySet()) {
                newState = newState.addAdditionalState(entry.getKey(), entry.getValue());
            }
            return newState;
        }
    }
}

