/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.forces.gravity.potential;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.hipparchus.exception.Localizable;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.forces.gravity.potential.OceanTidesReader;

public class FESCnmSnmReader
extends OceanTidesReader {
    private static final String UNKNOWN_TYPE_PATTERN = "\\S+";
    private static final String INTEGER_TYPE_PATTERN = "[-+]?\\p{Digit}+";
    private static final String REAL_TYPE_PATTERN = "[-+]?(?:(?:\\p{Digit}+(?:\\.\\p{Digit}*)?)|(?:\\.\\p{Digit}+))(?:[eE][-+]?\\p{Digit}+)?";
    private static final String DOODSON_TYPE_PATTERN = "\\p{Digit}{2,3}[.,]\\p{Digit}{3}";
    private static final Pattern PATTERN = Pattern.compile("[.,]");
    private final double scale;

    public FESCnmSnmReader(String supportedNames, double scale) {
        super(supportedNames);
        this.scale = scale;
    }

    @Override
    public void loadData(InputStream input, String name) throws IOException {
        String[] fieldsPatterns = new String[]{DOODSON_TYPE_PATTERN, UNKNOWN_TYPE_PATTERN, INTEGER_TYPE_PATTERN, INTEGER_TYPE_PATTERN, REAL_TYPE_PATTERN, REAL_TYPE_PATTERN, REAL_TYPE_PATTERN, REAL_TYPE_PATTERN};
        StringBuilder builder = new StringBuilder("^\\p{Space}*");
        for (int i = 0; i < fieldsPatterns.length; ++i) {
            builder.append("(");
            builder.append(fieldsPatterns[i]);
            builder.append(")");
            builder.append(i < fieldsPatterns.length - 1 ? "\\p{Space}+" : "\\p{Space}*$");
        }
        Pattern regularLinePattern = Pattern.compile(builder.toString());
        this.startParse(name);
        try (BufferedReader r = new BufferedReader(new InputStreamReader(input, StandardCharsets.UTF_8));){
            int lineNumber = 0;
            boolean dataStarted = false;
            String line = r.readLine();
            while (line != null) {
                ++lineNumber;
                Matcher regularMatcher = regularLinePattern.matcher(line);
                if (regularMatcher.matches()) {
                    int m;
                    int doodson = Integer.parseInt(PATTERN.matcher(regularMatcher.group(1)).replaceAll(""));
                    int n = Integer.parseInt(regularMatcher.group(3));
                    if (this.canAdd(n, m = Integer.parseInt(regularMatcher.group(4)))) {
                        double cPlus = this.scale * Double.parseDouble(regularMatcher.group(5));
                        double sPlus = this.scale * Double.parseDouble(regularMatcher.group(6));
                        double cMinus = this.scale * Double.parseDouble(regularMatcher.group(7));
                        double sMinus = this.scale * Double.parseDouble(regularMatcher.group(8));
                        this.addWaveCoefficients(doodson, n, m, cPlus, sPlus, cMinus, sMinus, lineNumber, line);
                        dataStarted = true;
                    }
                } else if (dataStarted) {
                    throw new OrekitException((Localizable)OrekitMessages.UNABLE_TO_PARSE_LINE_IN_FILE, lineNumber, name, line);
                }
                line = r.readLine();
            }
        }
        this.endParse();
    }
}

