/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.forces.empirical;

import org.hipparchus.RealFieldElement;
import org.hipparchus.util.FastMath;
import org.orekit.forces.empirical.AccelerationModel;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.SpacecraftState;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.ParameterDriver;

public class HarmonicAccelerationModel
implements AccelerationModel {
    private static final double AMPLITUDE_SCALE = FastMath.scalb((double)1.0, (int)-20);
    private static final double PHASE_SCALE = FastMath.scalb((double)1.0, (int)-23);
    private final ParameterDriver[] drivers;
    private AbsoluteDate referenceDate;
    private final double omega;

    public HarmonicAccelerationModel(String prefix, AbsoluteDate referenceDate, double fundamentalPeriod, int harmonicMultiplier) {
        this.referenceDate = referenceDate;
        this.omega = (double)harmonicMultiplier * (Math.PI * 2) / fundamentalPeriod;
        this.drivers = new ParameterDriver[]{new ParameterDriver(prefix + " \u03b3", 0.0, AMPLITUDE_SCALE, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY), new ParameterDriver(prefix + " \u03c6", 0.0, PHASE_SCALE, Math.PI * -2, Math.PI * 2)};
    }

    @Override
    public void init(SpacecraftState initialState, AbsoluteDate target) {
        if (this.referenceDate == null) {
            this.referenceDate = initialState.getDate();
        }
    }

    @Override
    public double signedAmplitude(SpacecraftState state, double[] parameters) {
        double dt = state.getDate().durationFrom(this.referenceDate);
        return parameters[0] * FastMath.sin((double)(dt * this.omega + parameters[1]));
    }

    @Override
    public <T extends RealFieldElement<T>> T signedAmplitude(FieldSpacecraftState<T> state, T[] parameters) {
        T dt = state.getDate().durationFrom(this.referenceDate);
        return (T)((RealFieldElement)parameters[0].multiply(((RealFieldElement)((RealFieldElement)dt.multiply(this.omega)).add(parameters[1])).sin()));
    }

    @Override
    public ParameterDriver[] getParametersDrivers() {
        return (ParameterDriver[])this.drivers.clone();
    }
}

