/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.general;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.orekit.files.general.EphemerisSegmentPropagator;
import org.orekit.frames.Frame;
import org.orekit.propagation.BoundedPropagator;
import org.orekit.propagation.analytical.AggregateBoundedPropagator;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.TimeScale;
import org.orekit.utils.CartesianDerivativesFilter;
import org.orekit.utils.TimeStampedPVCoordinates;

public interface EphemerisFile {
    public Map<String, ? extends SatelliteEphemeris> getSatellites();

    public static interface EphemerisSegment {
        public double getMu();

        public String getFrameCenterString();

        public String getFrameString();

        public Frame getFrame();

        default public Frame getInertialFrame() {
            Frame frame = this.getFrame();
            if (frame.isPseudoInertial()) {
                return frame;
            }
            return Frame.getRoot();
        }

        public String getTimeScaleString();

        public TimeScale getTimeScale();

        public int getInterpolationSamples();

        public CartesianDerivativesFilter getAvailableDerivatives();

        public List<? extends TimeStampedPVCoordinates> getCoordinates();

        public AbsoluteDate getStart();

        public AbsoluteDate getStop();

        default public BoundedPropagator getPropagator() {
            return new EphemerisSegmentPropagator(this);
        }
    }

    public static interface SatelliteEphemeris {
        public String getId();

        public double getMu();

        public List<? extends EphemerisSegment> getSegments();

        public AbsoluteDate getStart();

        public AbsoluteDate getStop();

        default public BoundedPropagator getPropagator() {
            ArrayList<BoundedPropagator> propagators = new ArrayList<BoundedPropagator>();
            for (EphemerisSegment ephemerisSegment : this.getSegments()) {
                propagators.add(ephemerisSegment.getPropagator());
            }
            return new AggregateBoundedPropagator(propagators);
        }
    }
}

