/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds;

import java.io.IOException;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import org.hipparchus.exception.Localizable;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.geometry.euclidean.threed.RotationOrder;
import org.orekit.errors.OrekitException;
import org.orekit.files.ccsds.AEMAttitudeType;
import org.orekit.files.ccsds.AEMParser;
import org.orekit.files.ccsds.Keyword;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.sampling.OrekitFixedStepHandler;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.DateTimeComponents;
import org.orekit.time.TimeComponents;
import org.orekit.time.TimeScale;
import org.orekit.utils.TimeStampedAngularCoordinates;

public class StreamingAemWriter {
    public static final String CCSDS_AEM_VERS = "1.0";
    public static final String DEFAULT_ORIGINATOR = "OREKIT";
    public static final String DEFAULT_ATTITUDE_FORMAT = "% .5f";
    private static final String NEW_LINE = "\n";
    private static final Locale STANDARDIZED_LOCALE = Locale.US;
    private static final String KV_FORMAT = "%s = %s%n";
    private final Appendable writer;
    private final Map<Keyword, String> metadata;
    private final TimeScale timeScale;
    private final String attitudeFormat;

    public StreamingAemWriter(Appendable writer, TimeScale timeScale, Map<Keyword, String> metadata) {
        this(writer, timeScale, metadata, DEFAULT_ATTITUDE_FORMAT);
    }

    public StreamingAemWriter(Appendable writer, TimeScale timeScale, Map<Keyword, String> metadata, String attitudeFormat) {
        this.writer = writer;
        this.timeScale = timeScale;
        this.metadata = new LinkedHashMap<Keyword, String>(metadata);
        this.metadata.putIfAbsent(Keyword.CCSDS_AEM_VERS, CCSDS_AEM_VERS);
        this.metadata.putIfAbsent(Keyword.CREATION_DATE, ZonedDateTime.now(ZoneOffset.UTC).format(DateTimeFormatter.ISO_INSTANT));
        this.metadata.putIfAbsent(Keyword.ORIGINATOR, DEFAULT_ORIGINATOR);
        this.metadata.putIfAbsent(Keyword.TIME_SYSTEM, timeScale.getName());
        this.attitudeFormat = attitudeFormat;
    }

    private void writeKeyValue(Keyword key, String value) throws IOException {
        this.writer.append(String.format(STANDARDIZED_LOCALE, KV_FORMAT, key.toString(), value));
    }

    public void writeHeader() throws IOException {
        this.writeKeyValue(Keyword.CCSDS_AEM_VERS, this.metadata.get((Object)Keyword.CCSDS_AEM_VERS));
        String comment = this.metadata.get((Object)Keyword.COMMENT);
        if (comment != null) {
            this.writeKeyValue(Keyword.COMMENT, comment);
        }
        this.writeKeyValue(Keyword.CREATION_DATE, this.metadata.get((Object)Keyword.CREATION_DATE));
        this.writeKeyValue(Keyword.ORIGINATOR, this.metadata.get((Object)Keyword.ORIGINATOR));
        this.writer.append(NEW_LINE);
    }

    public AEMSegment newSegment(Map<Keyword, String> segmentMetadata) {
        LinkedHashMap<Keyword, String> meta = new LinkedHashMap<Keyword, String>(this.metadata);
        meta.putAll(segmentMetadata);
        return new AEMSegment(meta);
    }

    static String dateToString(DateTimeComponents components) {
        TimeComponents time = components.getTime();
        int hour = time.getHour();
        int minute = time.getMinute();
        double second = time.getSecond();
        DecimalFormatSymbols locale = new DecimalFormatSymbols(STANDARDIZED_LOCALE);
        DecimalFormat twoDigits = new DecimalFormat("00", locale);
        DecimalFormat precise = new DecimalFormat("00.0########", locale);
        return components.getDate().toString() + "T" + twoDigits.format(hour) + ":" + twoDigits.format(minute) + ":" + precise.format(second);
    }

    public class AEMSegment
    implements OrekitFixedStepHandler {
        private final Map<Keyword, String> metadata;

        private AEMSegment(Map<Keyword, String> metadata) {
            this.metadata = metadata;
        }

        public void writeMetadata() throws IOException {
            String interpolationDegree;
            String interpolationMethod;
            String rateFrame;
            String eulerRotSeq;
            String usableStopTime;
            StreamingAemWriter.this.writer.append("META_START").append(StreamingAemWriter.NEW_LINE);
            StreamingAemWriter.this.writeKeyValue(Keyword.OBJECT_NAME, this.metadata.get((Object)Keyword.OBJECT_NAME));
            StreamingAemWriter.this.writeKeyValue(Keyword.OBJECT_ID, this.metadata.get((Object)Keyword.OBJECT_ID));
            StreamingAemWriter.this.writeKeyValue(Keyword.CENTER_NAME, this.metadata.get((Object)Keyword.CENTER_NAME));
            StreamingAemWriter.this.writeKeyValue(Keyword.REF_FRAME_A, this.metadata.get((Object)Keyword.REF_FRAME_A));
            StreamingAemWriter.this.writeKeyValue(Keyword.REF_FRAME_B, this.metadata.get((Object)Keyword.REF_FRAME_B));
            StreamingAemWriter.this.writeKeyValue(Keyword.ATTITUDE_DIR, this.metadata.get((Object)Keyword.ATTITUDE_DIR));
            StreamingAemWriter.this.writeKeyValue(Keyword.TIME_SYSTEM, this.metadata.get((Object)Keyword.TIME_SYSTEM));
            StreamingAemWriter.this.writeKeyValue(Keyword.START_TIME, this.metadata.get((Object)Keyword.START_TIME));
            String usableStartTime = this.metadata.get((Object)Keyword.USEABLE_START_TIME);
            if (usableStartTime != null) {
                StreamingAemWriter.this.writeKeyValue(Keyword.USEABLE_START_TIME, usableStartTime);
            }
            if ((usableStopTime = this.metadata.get((Object)Keyword.USEABLE_STOP_TIME)) != null) {
                StreamingAemWriter.this.writeKeyValue(Keyword.USEABLE_STOP_TIME, usableStopTime);
            }
            StreamingAemWriter.this.writeKeyValue(Keyword.STOP_TIME, this.metadata.get((Object)Keyword.STOP_TIME));
            StreamingAemWriter.this.writeKeyValue(Keyword.ATTITUDE_TYPE, this.metadata.get((Object)Keyword.ATTITUDE_TYPE));
            String quaternionType = this.metadata.get((Object)Keyword.QUATERNION_TYPE);
            if (quaternionType != null) {
                StreamingAemWriter.this.writeKeyValue(Keyword.QUATERNION_TYPE, quaternionType);
            }
            if ((eulerRotSeq = this.metadata.get((Object)Keyword.EULER_ROT_SEQ)) != null) {
                StreamingAemWriter.this.writeKeyValue(Keyword.EULER_ROT_SEQ, eulerRotSeq);
            }
            if ((rateFrame = this.metadata.get((Object)Keyword.RATE_FRAME)) != null) {
                StreamingAemWriter.this.writeKeyValue(Keyword.RATE_FRAME, rateFrame);
            }
            if ((interpolationMethod = this.metadata.get((Object)Keyword.INTERPOLATION_METHOD)) != null) {
                StreamingAemWriter.this.writeKeyValue(Keyword.INTERPOLATION_METHOD, interpolationMethod);
            }
            if ((interpolationDegree = this.metadata.get((Object)Keyword.INTERPOLATION_DEGREE)) != null) {
                StreamingAemWriter.this.writeKeyValue(Keyword.INTERPOLATION_DEGREE, interpolationDegree);
            }
            StreamingAemWriter.this.writer.append("META_STOP").append(StreamingAemWriter.NEW_LINE).append(StreamingAemWriter.NEW_LINE);
        }

        public void writeAttitudeEphemerisLine(TimeStampedAngularCoordinates attitude, boolean isFirst, String attitudeName, RotationOrder rotationOrder) throws IOException {
            String epoch = StreamingAemWriter.dateToString(attitude.getDate().getComponents(StreamingAemWriter.this.timeScale));
            StreamingAemWriter.this.writer.append(epoch).append(" ");
            AEMAttitudeType type = AEMAttitudeType.getAttitudeType(attitudeName);
            double[] data = type.getAttitudeData(attitude, isFirst, rotationOrder);
            int size = data.length;
            for (int index = 0; index < size; ++index) {
                StreamingAemWriter.this.writer.append(String.format(STANDARDIZED_LOCALE, StreamingAemWriter.this.attitudeFormat, data[index]));
                String space = index == size - 1 ? "" : " ";
                StreamingAemWriter.this.writer.append(space);
            }
            StreamingAemWriter.this.writer.append(StreamingAemWriter.NEW_LINE);
        }

        @Override
        public void init(SpacecraftState s0, AbsoluteDate t, double step) {
            try {
                String start = StreamingAemWriter.dateToString(s0.getDate().getComponents(StreamingAemWriter.this.timeScale));
                String stop = StreamingAemWriter.dateToString(t.getComponents(StreamingAemWriter.this.timeScale));
                this.metadata.putIfAbsent(Keyword.START_TIME, start);
                this.metadata.putIfAbsent(Keyword.STOP_TIME, stop);
                this.writeMetadata();
            }
            catch (IOException e) {
                throw new OrekitException(e, (Localizable)LocalizedCoreFormats.SIMPLE_MESSAGE, e.getLocalizedMessage());
            }
        }

        @Override
        public void handleStep(SpacecraftState currentState, boolean isLast) {
            try {
                String quaternionType = this.metadata.get((Object)Keyword.QUATERNION_TYPE);
                boolean isFirst = false;
                if (quaternionType != null) {
                    isFirst = quaternionType.equals("FIRST");
                }
                String attitudeType = this.metadata.get((Object)Keyword.ATTITUDE_TYPE);
                String eulerRotSeq = this.metadata.get((Object)Keyword.EULER_ROT_SEQ);
                RotationOrder order = eulerRotSeq == null ? null : AEMParser.AEMRotationOrder.getRotationOrder(eulerRotSeq);
                this.writeAttitudeEphemerisLine(currentState.getAttitude().getOrientation(), isFirst, attitudeType, order);
            }
            catch (IOException e) {
                throw new OrekitException(e, (Localizable)LocalizedCoreFormats.SIMPLE_MESSAGE, e.getLocalizedMessage());
            }
        }

        void startAttitudeBlock() throws IOException {
            StreamingAemWriter.this.writer.append("DATA_START").append(StreamingAemWriter.NEW_LINE);
        }

        void endAttitudeBlock() throws IOException {
            StreamingAemWriter.this.writer.append("DATA_STOP").append(StreamingAemWriter.NEW_LINE);
        }
    }
}

