/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds;

import java.util.ArrayList;
import java.util.List;
import org.hipparchus.exception.Localizable;
import org.orekit.data.DataContext;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.IERSConventions;

public abstract class NDMFile {
    private double formatVersion;
    private List<String> headerComment;
    private AbsoluteDate creationDate;
    private String originator;
    private DataContext dataContext;
    private IERSConventions conventions;
    private double mu = Double.NaN;
    private AbsoluteDate missionReferenceDate;

    public NDMFile() {
        this.headerComment = new ArrayList<String>();
    }

    public double getMu() {
        return this.mu;
    }

    public void setMu(double mu) {
        this.mu = mu;
    }

    public double getFormatVersion() {
        return this.formatVersion;
    }

    public void setFormatVersion(double formatVersion) {
        this.formatVersion = formatVersion;
    }

    public List<String> getHeaderComment() {
        return this.headerComment;
    }

    public void setHeaderComment(List<String> headerComment) {
        this.headerComment = new ArrayList<String>(headerComment);
    }

    public AbsoluteDate getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(AbsoluteDate creationDate) {
        this.creationDate = creationDate;
    }

    public String getOriginator() {
        return this.originator;
    }

    public void setOriginator(String originator) {
        this.originator = originator;
    }

    public IERSConventions getConventions() {
        if (this.conventions != null) {
            return this.conventions;
        }
        throw new OrekitException((Localizable)OrekitMessages.CCSDS_UNKNOWN_CONVENTIONS, new Object[0]);
    }

    public void setConventions(IERSConventions conventions) {
        this.conventions = conventions;
    }

    public AbsoluteDate getMissionReferenceDate() {
        return this.missionReferenceDate;
    }

    public void setMissionReferenceDate(AbsoluteDate missionReferenceDate) {
        this.missionReferenceDate = missionReferenceDate;
    }

    public DataContext getDataContext() {
        return this.dataContext;
    }

    public void setDataContext(DataContext dataContext) {
        this.dataContext = dataContext;
    }
}

