/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.measurements.gnss;

import java.util.Arrays;
import java.util.HashMap;
import org.hipparchus.RealFieldElement;
import org.hipparchus.analysis.differentiation.Gradient;
import org.orekit.estimation.measurements.AbstractMeasurement;
import org.orekit.estimation.measurements.EstimatedMeasurement;
import org.orekit.estimation.measurements.ObservableSatellite;
import org.orekit.propagation.SpacecraftState;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.utils.FieldPVCoordinates;
import org.orekit.utils.PVCoordinates;
import org.orekit.utils.PVCoordinatesProvider;
import org.orekit.utils.ParameterDriver;
import org.orekit.utils.TimeStampedFieldPVCoordinates;
import org.orekit.utils.TimeStampedPVCoordinates;

public class OneWayGNSSPhase
extends AbstractMeasurement<OneWayGNSSPhase> {
    public static final String AMBIGUITY_NAME = "ambiguity";
    private final ParameterDriver ambiguityDriver = new ParameterDriver("ambiguity", 0.0, 1.0, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
    private final PVCoordinatesProvider remote;
    private final double dtRemote;
    private final double wavelength;

    public OneWayGNSSPhase(PVCoordinatesProvider remote, double dtRemote, AbsoluteDate date, double phase, double wavelength, double sigma, double baseWeight, ObservableSatellite local) {
        super(date, phase, sigma, baseWeight, Arrays.asList(local));
        this.addParameterDriver(this.ambiguityDriver);
        this.addParameterDriver(local.getClockOffsetDriver());
        this.dtRemote = dtRemote;
        this.remote = remote;
        this.wavelength = wavelength;
    }

    public double getWavelength() {
        return this.wavelength;
    }

    public ParameterDriver getAmbiguityDriver() {
        return this.ambiguityDriver;
    }

    @Override
    protected EstimatedMeasurement<OneWayGNSSPhase> theoreticalEvaluation(int iteration, int evaluation, SpacecraftState[] states) {
        int nbEstimatedParamsPhase = 6;
        HashMap<String, Integer> parameterIndicesPhase = new HashMap<String, Integer>();
        for (ParameterDriver phaseMeasurementDriver : this.getParametersDrivers()) {
            if (!phaseMeasurementDriver.isSelected()) continue;
            parameterIndicesPhase.put(phaseMeasurementDriver.getName(), nbEstimatedParamsPhase++);
        }
        SpacecraftState localState = states[0];
        TimeStampedFieldPVCoordinates<Gradient> pvaLocal = OneWayGNSSPhase.getCoordinates(localState, 0, nbEstimatedParamsPhase);
        TimeStampedPVCoordinates pvaRemote = this.remote.getPVCoordinates(this.getDate(), localState.getFrame());
        Gradient dtLocal = this.getSatellites().get(0).getClockOffsetDriver().getValue(nbEstimatedParamsPhase, parameterIndicesPhase);
        FieldAbsoluteDate<Gradient> arrivalDate = new FieldAbsoluteDate<Gradient>(this.getDate(), dtLocal.negate());
        FieldPVCoordinates s1Downlink = pvaLocal.shiftedBy((RealFieldElement)arrivalDate.durationFrom(pvaLocal.getDate()));
        Gradient tauD = OneWayGNSSPhase.signalTimeOfFlight(new TimeStampedFieldPVCoordinates<Gradient>(pvaRemote.getDate(), dtLocal.getField().getOne(), (PVCoordinates)pvaRemote), s1Downlink.getPosition(), arrivalDate);
        double delta = this.getDate().durationFrom(pvaRemote.getDate());
        Gradient deltaMTauD = tauD.negate().add(delta);
        EstimatedMeasurement<OneWayGNSSPhase> estimatedPhase = new EstimatedMeasurement<OneWayGNSSPhase>(this, iteration, evaluation, new SpacecraftState[]{localState.shiftedBy(deltaMTauD.getValue())}, new TimeStampedPVCoordinates[]{pvaRemote.shiftedBy(delta - tauD.getValue()), localState.shiftedBy(delta).getPVCoordinates()});
        double cOverLambda = 2.99792458E8 / this.wavelength;
        Gradient ambiguity = this.ambiguityDriver.getValue(nbEstimatedParamsPhase, parameterIndicesPhase);
        Gradient phase = tauD.add(dtLocal).subtract(this.dtRemote).multiply(cOverLambda).add(ambiguity);
        double[] phaseDerivatives = phase.getGradient();
        estimatedPhase.setEstimatedValue(phase.getValue());
        estimatedPhase.setStateDerivatives(0, new double[][]{Arrays.copyOfRange(phaseDerivatives, 0, 6)});
        for (ParameterDriver phaseMeasurementDriver : this.getParametersDrivers()) {
            Integer index = (Integer)parameterIndicesPhase.get(phaseMeasurementDriver.getName());
            if (index == null) continue;
            estimatedPhase.setParameterDerivatives(phaseMeasurementDriver, phaseDerivatives[index]);
        }
        return estimatedPhase;
    }
}

