/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.measurements.gnss;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.orekit.estimation.measurements.gnss.CycleSlipDetectorResults;
import org.orekit.estimation.measurements.gnss.CycleSlipDetectors;
import org.orekit.gnss.Frequency;
import org.orekit.gnss.ObservationDataSet;
import org.orekit.gnss.SatelliteSystem;
import org.orekit.time.AbsoluteDate;

public abstract class AbstractCycleSlipDetector
implements CycleSlipDetectors {
    private static final String SEPARATOR = " - ";
    private int minMeasurementNumber;
    private final double dt;
    private List<CycleSlipDetectorResults> data;
    private List<Map<Frequency, DataForDetection>> stuff;

    AbstractCycleSlipDetector(double dt, int n) {
        this.minMeasurementNumber = n;
        this.dt = dt;
        this.data = new ArrayList<CycleSlipDetectorResults>();
        this.stuff = new ArrayList<Map<Frequency, DataForDetection>>();
    }

    @Override
    public List<CycleSlipDetectorResults> detect(List<ObservationDataSet> observations) {
        for (ObservationDataSet observation : observations) {
            this.manageData(observation);
        }
        return this.getResults();
    }

    protected abstract void manageData(ObservationDataSet var1);

    protected int getMinMeasurementNumber() {
        return this.minMeasurementNumber;
    }

    protected double getMaxTimeBeetween2Measurement() {
        return this.dt;
    }

    protected List<CycleSlipDetectorResults> getResults() {
        return this.data;
    }

    protected List<Map<Frequency, DataForDetection>> getStuffReference() {
        return this.stuff;
    }

    protected void cycleSlipDataSet(String nameSat, AbsoluteDate date, double value, Frequency freq) {
        if (this.data.isEmpty()) {
            this.data.add(new CycleSlipDetectorResults(nameSat, date, freq));
            HashMap<Frequency, DataForDetection> newMap = new HashMap<Frequency, DataForDetection>();
            newMap.put(freq, new DataForDetection(value, date));
            this.stuff.add(newMap);
        } else if (!this.alreadyExist(nameSat, freq)) {
            for (CycleSlipDetectorResults r : this.data) {
                if (r.getSatelliteName().compareTo(nameSat) != 0) continue;
                r.addAtOtherFrequency(freq, date);
                Map<Frequency, DataForDetection> newMap = this.stuff.get(this.data.indexOf(r));
                newMap.put(freq, new DataForDetection(value, date));
                this.stuff.set(this.data.indexOf(r), newMap);
                return;
            }
            this.data.add(new CycleSlipDetectorResults(nameSat, date, freq));
            HashMap newMap = new HashMap();
            newMap.put(freq, new DataForDetection(value, date));
            this.stuff.add(newMap);
        } else {
            this.addValue(nameSat, date, value, freq);
        }
    }

    protected String setName(int numSat, SatelliteSystem sys) {
        return sys.name() + SEPARATOR + numSat;
    }

    private boolean alreadyExist(String nameSat, Frequency freq) {
        if (this.data != null) {
            for (CycleSlipDetectorResults result : this.data) {
                if (result.getSatelliteName().compareTo(nameSat) != 0) continue;
                return result.getCycleSlipMap().containsKey((Object)freq);
            }
        }
        return false;
    }

    private void addValue(String nameSat, AbsoluteDate date, double value, Frequency frequency) {
        for (CycleSlipDetectorResults result : this.data) {
            if (result.getSatelliteName().compareTo(nameSat) != 0 || !result.getCycleSlipMap().containsKey((Object)frequency)) continue;
            Map<Frequency, DataForDetection> valuesMap = this.stuff.get(this.data.indexOf(result));
            DataForDetection detect = valuesMap.get((Object)frequency);
            detect.write = (detect.write + 1) % this.minMeasurementNumber;
            ((DataForDetection)detect).figures[((DataForDetection)detect).write] = new SlipComputationData(value, date);
            result.setDate(frequency, date);
            detect.canBeComputed++;
            break;
        }
    }

    class DataForDetection {
        private SlipComputationData[] figures;
        private int write;
        private int canBeComputed;

        DataForDetection(double value, AbsoluteDate date) {
            this.figures = new SlipComputationData[AbstractCycleSlipDetector.this.minMeasurementNumber];
            this.figures[0] = new SlipComputationData(value, date);
            this.canBeComputed = 1;
            this.write = 0;
        }

        protected SlipComputationData[] getFiguresReference() {
            return this.figures;
        }

        protected int getWrite() {
            return this.write;
        }

        protected int getCanBeComputed() {
            return this.canBeComputed;
        }

        protected void resetFigures(SlipComputationData[] newF, double value, AbsoluteDate date) {
            this.figures = newF;
            this.figures[0] = new SlipComputationData(value, date);
            this.write = 0;
            this.canBeComputed = 1;
        }
    }

    static class SlipComputationData {
        private double value;
        private AbsoluteDate date;

        SlipComputationData(double value, AbsoluteDate date) {
            this.value = value;
            this.date = date;
        }

        protected double getValue() {
            return this.value;
        }

        protected AbsoluteDate getDate() {
            return this.date;
        }
    }
}

