/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.compiler.plugin;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.JavacTask;
import com.sun.source.util.Plugin;
import com.sun.source.util.TaskEvent;
import com.sun.source.util.TaskListener;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreeScanner;
import com.sun.source.util.Trees;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeInfo;
import java.util.EnumSet;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.tools.Diagnostic;
import org.orekit.annotation.DefaultDataContext;

@SupportedAnnotationTypes(value={"org.orekit.annotation.DefaultDataContext"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_8)
public class DefaultDataContextPlugin
implements Plugin,
TaskListener {
    static final String MESSAGE = "Use of the default data context from a scope not annotated with @DefaultDataContext. This code may be unintentionally using the default data context.";
    private static final Class<DefaultDataContext> ANNOTATION = DefaultDataContext.class;
    private Trees trees;

    @Override
    public String getName() {
        return "dataContextPlugin";
    }

    @Override
    public synchronized void init(JavacTask javacTask, String ... args) {
        javacTask.addTaskListener(this);
        this.trees = Trees.instance(javacTask);
    }

    @Override
    public void started(TaskEvent taskEvent) {
    }

    @Override
    public void finished(TaskEvent taskEvent) {
        if (taskEvent.getKind() == TaskEvent.Kind.ANALYZE) {
            CompilationUnitTree root = taskEvent.getCompilationUnit();
            root.accept(new AnnotationTreeScanner(root), null);
        }
    }

    private class AnnotationTreeScanner
    extends TreeScanner<Void, Void> {
        private final CompilationUnitTree root;

        AnnotationTreeScanner(CompilationUnitTree root) {
            this.root = root;
        }

        @Override
        public Void visitIdentifier(IdentifierTree identifierTree, Void aVoid) {
            this.check(identifierTree);
            return (Void)super.visitIdentifier(identifierTree, aVoid);
        }

        @Override
        public Void visitMemberSelect(MemberSelectTree memberSelectTree, Void aVoid) {
            this.check(memberSelectTree);
            return (Void)super.visitMemberSelect(memberSelectTree, aVoid);
        }

        @Override
        public Void visitNewClass(NewClassTree newClassTree, Void aVoid) {
            this.check(newClassTree);
            return (Void)super.visitNewClass(newClassTree, aVoid);
        }

        private void check(Tree tree) {
            Symbol element = TreeInfo.symbolFor((JCTree)tree);
            this.check(tree, element);
        }

        private void check(Tree tree, Element element) {
            if (this.isAnyElementAnnotated(element) && !this.isAnyElementAnnotated(DefaultDataContextPlugin.this.trees.getPath(this.root, tree))) {
                String message = "Use of the default data context from a scope not annotated with @DefaultDataContext. This code may be unintentionally using the default data context. Used: " + (Object)((Object)element.getKind()) + " " + element;
                DefaultDataContextPlugin.this.trees.printMessage(Diagnostic.Kind.WARNING, message, tree, this.root);
            }
        }

        private boolean isAnyElementAnnotated(Element element) {
            for (Element e = element; e != null; e = e.getEnclosingElement()) {
                if (e.getAnnotation(ANNOTATION) == null) continue;
                return true;
            }
            return false;
        }

        private boolean isAnyElementAnnotated(TreePath path) {
            EnumSet<Tree.Kind> toCheck = EnumSet.of(Tree.Kind.METHOD, Tree.Kind.CLASS, Tree.Kind.VARIABLE, Tree.Kind.INTERFACE, Tree.Kind.ENUM);
            for (TreePath next = path; next != null; next = next.getParentPath()) {
                if (!toCheck.contains((Object)next.getLeaf().getKind()) || DefaultDataContextPlugin.this.trees.getElement(next).getAnnotation(ANNOTATION) == null) continue;
                return true;
            }
            return false;
        }
    }
}

