/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.attitudes;

import org.hipparchus.RealFieldElement;
import org.hipparchus.exception.Localizable;
import org.hipparchus.geometry.euclidean.threed.FieldRotation;
import org.hipparchus.geometry.euclidean.threed.Rotation;
import org.hipparchus.geometry.euclidean.threed.RotationConvention;
import org.hipparchus.geometry.euclidean.threed.RotationOrder;
import org.orekit.attitudes.Attitude;
import org.orekit.attitudes.AttitudeProvider;
import org.orekit.attitudes.FieldAttitude;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.frames.FieldTransform;
import org.orekit.frames.Frame;
import org.orekit.frames.LOFType;
import org.orekit.frames.Transform;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.utils.FieldPVCoordinatesProvider;
import org.orekit.utils.PVCoordinatesProvider;
import org.orekit.utils.TimeStampedFieldPVCoordinates;
import org.orekit.utils.TimeStampedPVCoordinates;

public class LofOffset
implements AttitudeProvider {
    private LOFType type;
    private final Rotation offset;
    private final Frame inertialFrame;

    public LofOffset(Frame inertialFrame, LOFType type) {
        this(inertialFrame, type, RotationOrder.XYZ, 0.0, 0.0, 0.0);
    }

    public LofOffset(Frame inertialFrame, LOFType type, RotationOrder order, double alpha1, double alpha2, double alpha3) {
        this.type = type;
        this.offset = new Rotation(order, RotationConvention.VECTOR_OPERATOR, alpha1, alpha2, alpha3).revert();
        if (!inertialFrame.isPseudoInertial()) {
            throw new OrekitException((Localizable)OrekitMessages.NON_PSEUDO_INERTIAL_FRAME, inertialFrame.getName());
        }
        this.inertialFrame = inertialFrame;
    }

    @Override
    public Attitude getAttitude(PVCoordinatesProvider pvProv, AbsoluteDate date, Frame frame) {
        TimeStampedPVCoordinates pv = pvProv.getPVCoordinates(date, this.inertialFrame);
        Transform inertialToLof = this.type.transformFromInertial(date, pv);
        Transform frameToInertial = frame.getTransformTo(this.inertialFrame, date);
        Transform frameToLof = new Transform(date, frameToInertial, inertialToLof);
        return new Attitude(date, frame, this.offset.compose(frameToLof.getRotation(), RotationConvention.VECTOR_OPERATOR), this.offset.applyTo(frameToLof.getRotationRate()), this.offset.applyTo(frameToLof.getRotationAcceleration()));
    }

    @Override
    public <T extends RealFieldElement<T>> FieldAttitude<T> getAttitude(FieldPVCoordinatesProvider<T> pvProv, FieldAbsoluteDate<T> date, Frame frame) {
        TimeStampedFieldPVCoordinates<T> pv = pvProv.getPVCoordinates(date, this.inertialFrame);
        FieldTransform<T> inertialToLof = this.type.transformFromInertial(date, pv);
        FieldTransform<T> frameToInertial = frame.getTransformTo(this.inertialFrame, date);
        FieldTransform<T> frameToLof = new FieldTransform<T>(date, frameToInertial, inertialToLof);
        return new FieldAttitude<T>(date, frame, frameToLof.getRotation().compose(this.offset, RotationConvention.FRAME_TRANSFORM), FieldRotation.applyTo((Rotation)this.offset, frameToLof.getRotationRate()), FieldRotation.applyTo((Rotation)this.offset, frameToLof.getRotationAcceleration()));
    }
}

