/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.analysis.interpolation;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicInteger;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.MathArrays;

public class GridAxis
implements Serializable {
    private static final long serialVersionUID = 20180926L;
    private final double[] grid;
    private int n;
    private final AtomicInteger cache;

    public GridAxis(double[] grid, int n) throws MathIllegalArgumentException {
        if (grid.length < n) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.INSUFFICIENT_DIMENSION, grid.length, n);
        }
        MathArrays.checkOrder(grid);
        this.grid = (double[])grid.clone();
        this.n = n;
        this.cache = new AtomicInteger(0);
    }

    public int size() {
        return this.grid.length;
    }

    public int getN() {
        return this.n;
    }

    public double node(int index) {
        return this.grid[index];
    }

    public int interpolationIndex(double t) {
        int middleOffset;
        int iInf = middleOffset = (this.n - 1) / 2;
        int iSup = this.grid.length - (this.n - 1) + middleOffset;
        int cached = this.cache.get();
        int middle = cached + middleOffset;
        double aMid0 = this.grid[middle];
        double aMid1 = this.grid[middle + 1];
        if (t < aMid0) {
            if (middle == iInf) {
                return cached;
            }
        } else {
            if (t < aMid1) {
                return cached;
            }
            if (middle == iSup - 1) {
                return cached;
            }
        }
        double aInf = this.grid[iInf];
        double aSup = this.grid[iSup];
        while (iSup - iInf > 1) {
            int iInterp = (int)(((double)iInf * (aSup - t) + (double)iSup * (t - aInf)) / (aSup - aInf));
            int iMed = FastMath.max(iInf + 1, FastMath.min(iInterp, iSup - 1));
            if (t < this.grid[iMed]) {
                iSup = iMed;
                aSup = this.grid[iSup];
                continue;
            }
            iInf = iMed;
            aInf = this.grid[iInf];
        }
        int newCached = iInf - middleOffset;
        this.cache.compareAndSet(cached, newCached);
        return newCached;
    }
}

