/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.analysis.function;

import java.util.Arrays;
import org.hipparchus.analysis.ParametricUnivariateFunction;
import org.hipparchus.analysis.differentiation.DerivativeStructure;
import org.hipparchus.analysis.differentiation.UnivariateDifferentiableFunction;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.exception.NullArgumentException;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.MathUtils;

public class Sigmoid
implements UnivariateDifferentiableFunction {
    private final double lo;
    private final double hi;

    public Sigmoid() {
        this(0.0, 1.0);
    }

    public Sigmoid(double lo, double hi) {
        this.lo = lo;
        this.hi = hi;
    }

    @Override
    public double value(double x) {
        return Sigmoid.value(x, this.lo, this.hi);
    }

    private static double value(double x, double lo, double hi) {
        return lo + (hi - lo) / (1.0 + FastMath.exp(-x));
    }

    @Override
    public DerivativeStructure value(DerivativeStructure t) throws MathIllegalArgumentException {
        double[] f = new double[t.getOrder() + 1];
        double exp = FastMath.exp(-t.getValue());
        if (Double.isInfinite(exp)) {
            f[0] = this.lo;
            Arrays.fill(f, 1, f.length, 0.0);
        } else {
            double[] p = new double[f.length];
            double inv = 1.0 / (1.0 + exp);
            double coeff = this.hi - this.lo;
            for (int n = 0; n < f.length; ++n) {
                double v = 0.0;
                p[n] = 1.0;
                for (int k = n; k >= 0; --k) {
                    v = v * exp + p[k];
                    if (k > 1) {
                        p[k - 1] = (double)(n - k + 2) * p[k - 2] - (double)(k - 1) * p[k - 1];
                        continue;
                    }
                    p[0] = 0.0;
                }
                f[n] = (coeff *= inv) * v;
            }
            f[0] = f[0] + this.lo;
        }
        return t.compose(f);
    }

    public static class Parametric
    implements ParametricUnivariateFunction {
        @Override
        public double value(double x, double ... param) throws MathIllegalArgumentException, NullArgumentException {
            this.validateParameters(param);
            return Sigmoid.value(x, param[0], param[1]);
        }

        @Override
        public double[] gradient(double x, double ... param) throws MathIllegalArgumentException, NullArgumentException {
            this.validateParameters(param);
            double invExp1 = 1.0 / (1.0 + FastMath.exp(-x));
            return new double[]{1.0 - invExp1, invExp1};
        }

        private void validateParameters(double[] param) throws MathIllegalArgumentException, NullArgumentException {
            MathUtils.checkNotNull(param);
            MathUtils.checkDimension(param.length, 2);
        }
    }
}

