/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.rugged.los;

import java.util.stream.Stream;
import org.hipparchus.RealFieldElement;
import org.hipparchus.analysis.differentiation.Derivative;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.util.FastMath;
import org.orekit.rugged.los.TimeIndependentLOSTransform;
import org.orekit.rugged.utils.DerivativeGenerator;
import org.orekit.utils.ParameterDriver;
import org.orekit.utils.ParameterObserver;

public class FixedZHomothety
implements TimeIndependentLOSTransform {
    private final double SCALE = FastMath.scalb((double)1.0, (int)0);
    private double factor;
    private Derivative<?> factorDS;
    private final ParameterDriver factorDriver;

    public FixedZHomothety(String name, double factorvalue) {
        this.factor = factorvalue;
        this.factorDS = null;
        this.factorDriver = new ParameterDriver(name, factorvalue, this.SCALE, 0.0, Double.POSITIVE_INFINITY);
        this.factorDriver.addObserver(new ParameterObserver(){

            public void valueChanged(double previousValue, ParameterDriver driver) {
                FixedZHomothety.this.factor = 0.0;
                FixedZHomothety.this.factorDS = null;
            }
        });
    }

    @Override
    public Stream<ParameterDriver> getParametersDrivers() {
        return Stream.of(this.factorDriver);
    }

    @Override
    public Vector3D transformLOS(int i, Vector3D los) {
        if (this.factor == 0.0) {
            this.factor = this.factorDriver.getValue();
        }
        return new Vector3D(los.getX(), los.getY(), this.factor * los.getZ());
    }

    @Override
    public <T extends Derivative<T>> FieldVector3D<T> transformLOS(int i, FieldVector3D<T> los, DerivativeGenerator<T> generator) {
        Object factorD;
        if (this.factorDS == null || !this.factorDS.getField().equals(generator.getField())) {
            factorD = generator.variable(this.factorDriver);
            this.factorDS = factorD;
        } else {
            factorD = this.factorDS;
        }
        return new FieldVector3D(los.getX(), los.getY(), (RealFieldElement)factorD.multiply((Object)los.getZ()));
    }
}

