/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.rugged.linesensor;

import org.orekit.rugged.linesensor.LineDatation;
import org.orekit.time.AbsoluteDate;

public class LinearLineDatation
implements LineDatation {
    private final AbsoluteDate referenceDate;
    private final double referenceLine;
    private final double rate;

    public LinearLineDatation(AbsoluteDate referenceDate, double referenceLine, double rate) {
        this.referenceDate = referenceDate;
        this.referenceLine = referenceLine;
        this.rate = rate;
    }

    @Override
    public AbsoluteDate getDate(double lineNumber) {
        return this.referenceDate.shiftedBy((lineNumber - this.referenceLine) / this.rate);
    }

    @Override
    public double getLine(AbsoluteDate date) {
        return this.referenceLine + this.rate * date.durationFrom(this.referenceDate);
    }

    @Override
    public double getRate(double lineNumber) {
        return this.rate;
    }
}

