/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.rugged.intersection.duvenhage;

import org.hipparchus.geometry.Vector;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.util.FastMath;
import org.orekit.bodies.GeodeticPoint;
import org.orekit.rugged.api.AlgorithmId;
import org.orekit.rugged.errors.DumpManager;
import org.orekit.rugged.errors.RuggedException;
import org.orekit.rugged.errors.RuggedInternalError;
import org.orekit.rugged.errors.RuggedMessages;
import org.orekit.rugged.intersection.IntersectionAlgorithm;
import org.orekit.rugged.intersection.duvenhage.MinMaxTreeTile;
import org.orekit.rugged.intersection.duvenhage.MinMaxTreeTileFactory;
import org.orekit.rugged.raster.Tile;
import org.orekit.rugged.raster.TileUpdater;
import org.orekit.rugged.raster.TilesCache;
import org.orekit.rugged.utils.ExtendedEllipsoid;
import org.orekit.rugged.utils.NormalizedGeodeticPoint;

public class DuvenhageAlgorithm
implements IntersectionAlgorithm {
    private static final double STEP = 0.01;
    private static final int MAX_REFINING_ATTEMPTS = 100;
    private final TilesCache<MinMaxTreeTile> cache;
    private final boolean flatBody;
    private final AlgorithmId algorithmId;

    public DuvenhageAlgorithm(TileUpdater updater, int maxCachedTiles, boolean flatBody) {
        this.cache = new TilesCache<MinMaxTreeTile>(new MinMaxTreeTileFactory(), updater, maxCachedTiles);
        this.flatBody = flatBody;
        this.algorithmId = flatBody ? AlgorithmId.DUVENHAGE_FLAT_BODY : AlgorithmId.DUVENHAGE;
    }

    @Override
    public NormalizedGeodeticPoint intersection(ExtendedEllipsoid ellipsoid, Vector3D position, Vector3D los) {
        NormalizedGeodeticPoint intersection;
        int exitLon;
        int exitLat;
        int entryLon;
        int entryLat;
        NormalizedGeodeticPoint current;
        MinMaxTreeTile tile;
        block10: {
            LimitPoint exit;
            Vector3D forward;
            DumpManager.dumpAlgorithm(this.algorithmId);
            NormalizedGeodeticPoint gp0 = ellipsoid.pointOnGround(position, los, 0.0);
            tile = this.cache.getTile(gp0.getLatitude(), gp0.getLongitude());
            current = null;
            double hMax = tile.getMaxElevation();
            while (current == null) {
                Vector3D entryP = ellipsoid.pointAtAltitude(position, los, hMax + 0.01);
                if (Vector3D.dotProduct((Vector3D)entryP.subtract((Vector)position), (Vector3D)los) < 0.0) {
                    block9: {
                        try {
                            NormalizedGeodeticPoint positionGP = ellipsoid.transform(position, ellipsoid.getBodyFrame(), null, tile.getMinimumLongitude());
                            double elevationAtPosition = tile.interpolateElevation(positionGP.getLatitude(), positionGP.getLongitude());
                            current = positionGP.getAltitude() >= elevationAtPosition ? positionGP : null;
                        }
                        catch (RuggedException re) {
                            if (re.getSpecifier() != RuggedMessages.OUT_OF_TILE_ANGLES) break block9;
                            current = null;
                        }
                    }
                    if (current == null) {
                        throw new RuggedException(RuggedMessages.DEM_ENTRY_POINT_IS_BEHIND_SPACECRAFT, new Object[0]);
                    }
                } else {
                    current = ellipsoid.transform(entryP, ellipsoid.getBodyFrame(), null, tile.getMinimumLongitude());
                }
                if (tile.getLocation(current.getLatitude(), current.getLongitude()) == Tile.Location.HAS_INTERPOLATION_NEIGHBORS) continue;
                tile = this.cache.getTile(current.getLatitude(), current.getLongitude());
                hMax = FastMath.max((double)hMax, (double)tile.getMaxElevation());
                current = null;
            }
            do {
                exit = this.findExit(tile, ellipsoid, position, los);
                entryLat = FastMath.max((int)0, (int)FastMath.min((int)(tile.getLatitudeRows() - 1), (int)tile.getFloorLatitudeIndex(current.getLatitude())));
                entryLon = FastMath.max((int)0, (int)FastMath.min((int)(tile.getLongitudeColumns() - 1), (int)tile.getFloorLongitudeIndex(current.getLongitude())));
                exitLat = FastMath.max((int)0, (int)FastMath.min((int)(tile.getLatitudeRows() - 1), (int)tile.getFloorLatitudeIndex(exit.getPoint().getLatitude())));
                exitLon = FastMath.max((int)0, (int)FastMath.min((int)(tile.getLongitudeColumns() - 1), (int)tile.getFloorLongitudeIndex(exit.getPoint().getLongitude())));
                intersection = this.recurseIntersection(0, ellipsoid, position, los, tile, current, entryLat, entryLon, exit.getPoint(), exitLat, exitLon);
                if (intersection != null) {
                    return intersection;
                }
                if (!exit.atSide()) break block10;
            } while (!((tile = this.cache.getTile((current = ellipsoid.transform(forward = new Vector3D(1.0, ellipsoid.transform(exit.getPoint()), 0.01, los), ellipsoid.getBodyFrame(), null, tile.getMinimumLongitude())).getLatitude(), current.getLongitude())).interpolateElevation(current.getLatitude(), current.getLongitude()) >= current.getAltitude()));
            return current;
        }
        intersection = this.noRecurseIntersection(ellipsoid, position, los, tile, current, entryLat, entryLon, exitLat, exitLon);
        if (intersection != null) {
            return intersection;
        }
        throw new RuggedInternalError(null);
    }

    @Override
    public NormalizedGeodeticPoint refineIntersection(ExtendedEllipsoid ellipsoid, Vector3D position, Vector3D los, NormalizedGeodeticPoint closeGuess) {
        DumpManager.dumpAlgorithm(this.algorithmId);
        if (this.flatBody) {
            MinMaxTreeTile tile = this.cache.getTile(closeGuess.getLatitude(), closeGuess.getLongitude());
            Vector3D exitP = ellipsoid.pointAtAltitude(position, los, tile.getMinElevation());
            Vector3D entryP = ellipsoid.pointAtAltitude(position, los, tile.getMaxElevation());
            NormalizedGeodeticPoint entry = ellipsoid.transform(entryP, ellipsoid.getBodyFrame(), null, tile.getMinimumLongitude());
            return tile.cellIntersection(entry, ellipsoid.convertLos(entryP, exitP), tile.getFloorLatitudeIndex(closeGuess.getLatitude()), tile.getFloorLongitudeIndex(closeGuess.getLongitude()));
        }
        NormalizedGeodeticPoint currentGuess = closeGuess;
        for (int i = 0; i < 100; ++i) {
            int iLon;
            int iLat;
            Vector3D topoLOS;
            Vector3D delta = ellipsoid.transform(currentGuess).subtract((Vector)position);
            double s = Vector3D.dotProduct((Vector3D)delta, (Vector3D)los) / los.getNormSq();
            Vector3D projectedP = new Vector3D(1.0, position, s, los);
            GeodeticPoint projected = ellipsoid.transform(projectedP, ellipsoid.getBodyFrame(), null);
            NormalizedGeodeticPoint normalizedProjected = new NormalizedGeodeticPoint(projected.getLatitude(), projected.getLongitude(), projected.getAltitude(), currentGuess.getLongitude());
            MinMaxTreeTile tile = this.cache.getTile(normalizedProjected.getLatitude(), normalizedProjected.getLongitude());
            NormalizedGeodeticPoint foundIntersection = tile.cellIntersection(normalizedProjected, topoLOS = ellipsoid.convertLos(normalizedProjected, los), iLat = tile.getFloorLatitudeIndex(normalizedProjected.getLatitude()), iLon = tile.getFloorLongitudeIndex(normalizedProjected.getLongitude()));
            if (foundIntersection != null) {
                return foundIntersection;
            }
            double cellBoundaryLatitude = tile.getLatitudeAtIndex(topoLOS.getY() <= 0.0 ? iLat : iLat + 1);
            double cellBoundaryLongitude = tile.getLongitudeAtIndex(topoLOS.getX() <= 0.0 ? iLon : iLon + 1);
            Vector3D cellExit = new Vector3D(1.0, this.selectClosest(this.latitudeCrossing(ellipsoid, projectedP, los, cellBoundaryLatitude, projectedP), this.longitudeCrossing(ellipsoid, projectedP, los, cellBoundaryLongitude, projectedP), projectedP), 0.01, los);
            GeodeticPoint egp = ellipsoid.transform(cellExit, ellipsoid.getBodyFrame(), null);
            NormalizedGeodeticPoint cellExitGP = new NormalizedGeodeticPoint(egp.getLatitude(), egp.getLongitude(), egp.getAltitude(), currentGuess.getLongitude());
            if (tile.interpolateElevation(cellExitGP.getLatitude(), cellExitGP.getLongitude()) >= cellExitGP.getAltitude()) {
                return cellExitGP;
            }
            NormalizedGeodeticPoint currentGuessGP = this.intersection(ellipsoid, cellExit, los);
            currentGuess = new NormalizedGeodeticPoint(currentGuessGP.getLatitude(), currentGuessGP.getLongitude(), currentGuessGP.getAltitude(), projected.getLongitude());
        }
        return null;
    }

    @Override
    public double getElevation(double latitude, double longitude) {
        DumpManager.dumpAlgorithm(this.algorithmId);
        MinMaxTreeTile tile = this.cache.getTile(latitude, longitude);
        return tile.interpolateElevation(latitude, longitude);
    }

    @Override
    public AlgorithmId getAlgorithmId() {
        return this.algorithmId;
    }

    private NormalizedGeodeticPoint recurseIntersection(int depth, ExtendedEllipsoid ellipsoid, Vector3D position, Vector3D los, MinMaxTreeTile tile, NormalizedGeodeticPoint entry, int entryLat, int entryLon, NormalizedGeodeticPoint exit, int exitLat, int exitLon) {
        if (depth > 30) {
            throw new RuggedInternalError(null);
        }
        if (this.searchDomainSize(entryLat, entryLon, exitLat, exitLon) < 4) {
            return this.noRecurseIntersection(ellipsoid, position, los, tile, entry, entryLat, entryLon, exitLat, exitLon);
        }
        int level = tile.getMergeLevel(entryLat, entryLon, exitLat, exitLon);
        if (level >= 0 && exit.getAltitude() >= tile.getMaxElevation(exitLat, exitLon, level)) {
            return null;
        }
        NormalizedGeodeticPoint previousGP = entry;
        int previousLat = entryLat;
        int previousLon = entryLon;
        double angularMargin = 0.01 / ellipsoid.getEquatorialRadius();
        if (tile.isColumnMerging(level + 1)) {
            int[] crossings;
            for (int crossingLon : crossings = tile.getCrossedBoundaryColumns(previousLon, exitLon, level + 1)) {
                NormalizedGeodeticPoint intersection;
                double longitude = tile.getLongitudeAtIndex(crossingLon);
                if (!(longitude >= FastMath.min((double)entry.getLongitude(), (double)exit.getLongitude()) - angularMargin) || !(longitude <= FastMath.max((double)entry.getLongitude(), (double)exit.getLongitude()) + angularMargin)) continue;
                NormalizedGeodeticPoint crossingGP = null;
                if (!this.flatBody) {
                    try {
                        Vector3D crossingP = ellipsoid.pointAtLongitude(position, los, longitude);
                        crossingGP = ellipsoid.transform(crossingP, ellipsoid.getBodyFrame(), null, tile.getMinimumLongitude());
                    }
                    catch (RuggedException re) {
                        crossingGP = null;
                    }
                }
                if (crossingGP == null) {
                    double d = exit.getLongitude() - entry.getLongitude();
                    double cN = (exit.getLongitude() - longitude) / d;
                    double cX = (longitude - entry.getLongitude()) / d;
                    crossingGP = new NormalizedGeodeticPoint(cN * entry.getLatitude() + cX * exit.getLatitude(), longitude, cN * entry.getAltitude() + cX * exit.getAltitude(), tile.getMinimumLongitude());
                }
                int crossingLat = FastMath.max((int)0, (int)FastMath.min((int)(tile.getLatitudeRows() - 1), (int)tile.getFloorLatitudeIndex(crossingGP.getLatitude())));
                int crossingLonBefore = crossingLon - (entryLon <= exitLon ? 1 : 0);
                int crossingLonAfter = crossingLon - (entryLon <= exitLon ? 0 : 1);
                if (this.inRange(crossingLonBefore, entryLon, exitLon) && (intersection = this.searchDomainSize(previousLat, previousLon, crossingLat, crossingLonBefore) < this.searchDomainSize(entryLat, entryLon, exitLat, exitLon) ? this.recurseIntersection(depth + 1, ellipsoid, position, los, tile, previousGP, previousLat, previousLon, crossingGP, crossingLat, crossingLonBefore) : this.noRecurseIntersection(ellipsoid, position, los, tile, previousGP, previousLat, previousLon, crossingLat, crossingLonBefore)) != null) {
                    return intersection;
                }
                previousGP = crossingGP;
                previousLat = crossingLat;
                previousLon = crossingLonAfter;
            }
        } else {
            int[] crossings;
            for (int crossingLat : crossings = tile.getCrossedBoundaryRows(previousLat, exitLat, level + 1)) {
                NormalizedGeodeticPoint intersection;
                double latitude = tile.getLatitudeAtIndex(crossingLat);
                if (!(latitude >= FastMath.min((double)entry.getLatitude(), (double)exit.getLatitude()) - angularMargin) || !(latitude <= FastMath.max((double)entry.getLatitude(), (double)exit.getLatitude()) + angularMargin)) continue;
                NormalizedGeodeticPoint crossingGP = null;
                if (!this.flatBody) {
                    try {
                        Vector3D crossingP = ellipsoid.pointAtLatitude(position, los, tile.getLatitudeAtIndex(crossingLat), ellipsoid.transform(entry));
                        crossingGP = ellipsoid.transform(crossingP, ellipsoid.getBodyFrame(), null, tile.getMinimumLongitude());
                    }
                    catch (RuggedException re) {
                        crossingGP = null;
                    }
                }
                if (crossingGP == null) {
                    double d = exit.getLatitude() - entry.getLatitude();
                    double cN = (exit.getLatitude() - latitude) / d;
                    double cX = (latitude - entry.getLatitude()) / d;
                    crossingGP = new NormalizedGeodeticPoint(latitude, cN * entry.getLongitude() + cX * exit.getLongitude(), cN * entry.getAltitude() + cX * exit.getAltitude(), tile.getMinimumLongitude());
                }
                int crossingLon = FastMath.max((int)0, (int)FastMath.min((int)(tile.getLongitudeColumns() - 1), (int)tile.getFloorLongitudeIndex(crossingGP.getLongitude())));
                int crossingLatBefore = crossingLat - (entryLat <= exitLat ? 1 : 0);
                int crossingLatAfter = crossingLat - (entryLat <= exitLat ? 0 : 1);
                if (this.inRange(crossingLatBefore, entryLat, exitLat) && (intersection = this.searchDomainSize(previousLat, previousLon, crossingLatBefore, crossingLon) < this.searchDomainSize(entryLat, entryLon, exitLat, exitLon) ? this.recurseIntersection(depth + 1, ellipsoid, position, los, tile, previousGP, previousLat, previousLon, crossingGP, crossingLatBefore, crossingLon) : this.noRecurseIntersection(ellipsoid, position, los, tile, previousGP, previousLat, previousLon, crossingLatBefore, crossingLon)) != null) {
                    return intersection;
                }
                previousGP = crossingGP;
                previousLat = crossingLatAfter;
                previousLon = crossingLon;
            }
        }
        if (this.inRange(previousLat, entryLat, exitLat) && this.inRange(previousLon, entryLon, exitLon)) {
            if (this.searchDomainSize(previousLat, previousLon, exitLat, exitLon) < this.searchDomainSize(entryLat, entryLon, exitLat, exitLon)) {
                return this.recurseIntersection(depth + 1, ellipsoid, position, los, tile, previousGP, previousLat, previousLon, exit, exitLat, exitLon);
            }
            return this.noRecurseIntersection(ellipsoid, position, los, tile, previousGP, previousLat, previousLon, exitLat, exitLon);
        }
        return null;
    }

    private NormalizedGeodeticPoint noRecurseIntersection(ExtendedEllipsoid ellipsoid, Vector3D position, Vector3D los, MinMaxTreeTile tile, NormalizedGeodeticPoint entry, int entryLat, int entryLon, int exitLat, int exitLon) {
        NormalizedGeodeticPoint intersectionGP = null;
        double intersectionDot = Double.POSITIVE_INFINITY;
        for (int i = FastMath.min((int)entryLat, (int)exitLat); i <= FastMath.max((int)entryLat, (int)exitLat); ++i) {
            for (int j = FastMath.min((int)entryLon, (int)exitLon); j <= FastMath.max((int)entryLon, (int)exitLon); ++j) {
                Vector3D point;
                double dot;
                GeodeticPoint projected;
                NormalizedGeodeticPoint normalizedProjected;
                NormalizedGeodeticPoint gpImproved;
                Vector3D delta;
                double s;
                NormalizedGeodeticPoint gp = tile.cellIntersection(entry, ellipsoid.convertLos(entry, los), i, j);
                if (gp == null || !((s = Vector3D.dotProduct((Vector3D)(delta = ellipsoid.transform(gp).subtract((Vector)position)), (Vector3D)los) / los.getNormSq()) > 0.0) || (gpImproved = tile.cellIntersection(normalizedProjected = new NormalizedGeodeticPoint((projected = ellipsoid.transform(new Vector3D(1.0, position, s, los), ellipsoid.getBodyFrame(), null)).getLatitude(), projected.getLongitude(), projected.getAltitude(), gp.getLongitude()), ellipsoid.convertLos(normalizedProjected, los), i, j)) == null || !((dot = Vector3D.dotProduct((Vector3D)(point = ellipsoid.transform(gpImproved)).subtract((Vector)position), (Vector3D)los)) < intersectionDot)) continue;
                intersectionGP = gpImproved;
                intersectionDot = dot;
            }
        }
        return intersectionGP;
    }

    private int searchDomainSize(int entryLat, int entryLon, int exitLat, int exitLon) {
        return (FastMath.abs((int)(entryLat - exitLat)) + 1) * (FastMath.abs((int)(entryLon - exitLon)) + 1);
    }

    private boolean inRange(int i, int a, int b) {
        return i >= FastMath.min((int)a, (int)b) && i <= FastMath.max((int)a, (int)b);
    }

    private LimitPoint findExit(Tile tile, ExtendedEllipsoid ellipsoid, Vector3D position, Vector3D los) {
        double reference = tile.getMinimumLongitude();
        Vector3D exitP = ellipsoid.pointAtAltitude(position, los, tile.getMinElevation() - 0.01);
        NormalizedGeodeticPoint exitGP = ellipsoid.transform(exitP, ellipsoid.getBodyFrame(), null, reference);
        switch (tile.getLocation(exitGP.getLatitude(), exitGP.getLongitude())) {
            case SOUTH_WEST: {
                return new LimitPoint(ellipsoid, reference, this.selectClosest(this.latitudeCrossing(ellipsoid, position, los, tile.getMinimumLatitude(), exitP), this.longitudeCrossing(ellipsoid, position, los, tile.getMinimumLongitude(), exitP), position), true);
            }
            case WEST: {
                return new LimitPoint(ellipsoid, reference, this.longitudeCrossing(ellipsoid, position, los, tile.getMinimumLongitude(), exitP), true);
            }
            case NORTH_WEST: {
                return new LimitPoint(ellipsoid, reference, this.selectClosest(this.latitudeCrossing(ellipsoid, position, los, tile.getMaximumLatitude(), exitP), this.longitudeCrossing(ellipsoid, position, los, tile.getMinimumLongitude(), exitP), position), true);
            }
            case NORTH: {
                return new LimitPoint(ellipsoid, reference, this.latitudeCrossing(ellipsoid, position, los, tile.getMaximumLatitude(), exitP), true);
            }
            case NORTH_EAST: {
                return new LimitPoint(ellipsoid, reference, this.selectClosest(this.latitudeCrossing(ellipsoid, position, los, tile.getMaximumLatitude(), exitP), this.longitudeCrossing(ellipsoid, position, los, tile.getMaximumLongitude(), exitP), position), true);
            }
            case EAST: {
                return new LimitPoint(ellipsoid, reference, this.longitudeCrossing(ellipsoid, position, los, tile.getMaximumLongitude(), exitP), true);
            }
            case SOUTH_EAST: {
                return new LimitPoint(ellipsoid, reference, this.selectClosest(this.latitudeCrossing(ellipsoid, position, los, tile.getMinimumLatitude(), exitP), this.longitudeCrossing(ellipsoid, position, los, tile.getMaximumLongitude(), exitP), position), true);
            }
            case SOUTH: {
                return new LimitPoint(ellipsoid, reference, this.latitudeCrossing(ellipsoid, position, los, tile.getMinimumLatitude(), exitP), true);
            }
            case HAS_INTERPOLATION_NEIGHBORS: {
                return new LimitPoint(exitGP, false);
            }
        }
        throw new RuggedInternalError(null);
    }

    private Vector3D selectClosest(Vector3D p1, Vector3D p2, Vector3D position) {
        return Vector3D.distance((Vector3D)p1, (Vector3D)position) <= Vector3D.distance((Vector3D)p2, (Vector3D)position) ? p1 : p2;
    }

    private Vector3D latitudeCrossing(ExtendedEllipsoid ellipsoid, Vector3D position, Vector3D los, double latitude, Vector3D closeReference) {
        try {
            return ellipsoid.pointAtLatitude(position, los, latitude, closeReference);
        }
        catch (RuggedException re) {
            return closeReference;
        }
    }

    private Vector3D longitudeCrossing(ExtendedEllipsoid ellipsoid, Vector3D position, Vector3D los, double longitude, Vector3D closeReference) {
        try {
            return ellipsoid.pointAtLongitude(position, los, longitude);
        }
        catch (RuggedException re) {
            return closeReference;
        }
    }

    private static class LimitPoint {
        private final NormalizedGeodeticPoint point;
        private final boolean side;

        LimitPoint(ExtendedEllipsoid ellipsoid, double referenceLongitude, Vector3D cartesian, boolean side) {
            this(ellipsoid.transform(cartesian, ellipsoid.getBodyFrame(), null, referenceLongitude), side);
        }

        LimitPoint(NormalizedGeodeticPoint point, boolean side) {
            this.point = point;
            this.side = side;
        }

        public NormalizedGeodeticPoint getPoint() {
            return this.point;
        }

        public boolean atSide() {
            return this.side;
        }
    }
}

