/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.rugged.errors;

import java.text.MessageFormat;
import java.util.Locale;
import org.hipparchus.exception.Localizable;
import org.hipparchus.exception.LocalizedException;

public class RuggedException
extends RuntimeException
implements LocalizedException {
    private static final long serialVersionUID = 0x1335115L;
    private final Localizable specifier;
    private final Object[] parts;

    public RuggedException(Localizable specifier, Object ... parts) {
        this.specifier = specifier;
        this.parts = parts == null ? new Object[]{} : (Object[])parts.clone();
    }

    public RuggedException(Throwable cause, Localizable specifier, Object ... parts) {
        super(cause);
        this.specifier = specifier;
        this.parts = parts == null ? new Object[]{} : (Object[])parts.clone();
    }

    public String getMessage(Locale locale) {
        return RuggedException.buildMessage(locale, this.specifier, this.parts);
    }

    @Override
    public String getMessage() {
        return this.getMessage(Locale.US);
    }

    @Override
    public String getLocalizedMessage() {
        return this.getMessage(Locale.getDefault());
    }

    public Localizable getSpecifier() {
        return this.specifier;
    }

    public Object[] getParts() {
        return (Object[])this.parts.clone();
    }

    private static String buildMessage(Locale locale, Localizable specifier, Object ... parts) {
        return specifier == null ? "" : new MessageFormat(specifier.getLocalizedString(locale), locale).format(parts);
    }
}

